define(['angular'], function (angular) {
	"use strict";

	angular.module('TimeControls', [])
		.directive('timeControl', function ($timeout, formatter) {
			return {
				restrict: 'AE',
				require: 'ngModel',
				scope: {
					ngModel : "=",
					ngReadonly: '=',
					ngRequired: '=',
					ngDisabled: '=',
					fieldId : "@",
					futureValidationDate : "=",
					label : "@"
				},
				link: function(scope, elem, attrs, ngModelCtrl) {
					var inputArea = elem.find('input');

					scope.$watch('ngModel', function(){
						var time = new Date("12/12/1212 " + scope.ngModel);
						var hours = time.getHours();
						var minutes = time.getMinutes();

						if (isFormattedTime(scope.ngModel)) {
							scope.ngModel = formatter.getFormattedFrontendTime(hours + ":" + minutes);
						}
					});

					var validator = function(value) {
						var isValidPattern = isFormattedTime(value);
						ngModelCtrl.$setValidity('pattern', isValidPattern || scope.ngDisabled || !value);
						if(scope.futureValidationDate) {
							ngModelCtrl.$setValidity('future', !futureTime(scope.futureValidationDate, value));
						}
						return value;
					};
	                ngModelCtrl.$parsers.push(validator);
					ngModelCtrl.$formatters.push(validator);

	                var label = scope.label.lastIndexOf(":") === scope.label.length - 1 ? scope.label.substr(0, scope.label.length - 1) : scope.label;

	                scope.$watch('ngDisabled', function (newVal) {
						validator(scope.ngModel);
					}, true);

					scope.$watch("futureValidationDate", function(newVal){
						if(newVal){
							ngModelCtrl.$setValidity('future', !futureTime(newVal, scope.ngModel));
	                	} else {
	                		ngModelCtrl.$setValidity('future', true);
	                	}
					});

	               	scope.errorHandling = {
		                'required' : {
		                    message : label + ' field is required.',
		                    priority : 1
		                },
	                	'pattern' : {
	                		message: label + " must be formatted hh:mm (AM/PM).",
	                		priority: 2
						},
	                	'future' : {
	                		message: label + " cannot be a future time.",
	                		priority: 3
	                	}
	                };

					var tokenizeTimeString = function(timeString){
						var tokens;
						var timeSplit;
						if(timeString !== undefined && timeString !== null){
							var start = 0;
							var end = timeString.indexOf(":");

							tokens = ["", "", "", "", ""];

							if(end === -1) {
								end = timeString.length;
							} else {
								tokens[1] = ":";
							}

							end = end - start > 2 ? 2 : end - start;

							tokens[0] = timeString.substr(start, end);

							start = start + end + (tokens[1] === ":" ? 1 : 0);
							end = timeString.indexOf(" ");

							if(end === -1) {
								end = timeString.length
							} else {
								tokens[3] = " ";
							}

							end = end - start > 2 ? 2 : end - start;

							tokens[2] = timeString.substr(start, end);

							tokens[4] = timeString.substr(start + end + (tokens[3] === " " ? 1 : 0), 2);
						}

						return tokens || ["", "", "", "", ""];
					};

					var prevTimeTokens = tokenizeTimeString(scope.ngModel);

                	var hourRegExp = /^(0[1-9]?|1[0-2]?)?$/;
                	var minuteRegExp = /^([0-5][0-9]?)?$/;
                	var periodRegExp = /^([APap][Mm]?)?$/;

					var selectionStart = inputArea[0].selectionStart;
					var selectionEnd = inputArea[0].selectionEnd;

					scope.onChange = function(){
						var timeTokens = tokenizeTimeString(scope.ngModel);
						var prevTime = prevTimeTokens.join("");
	                	var formattedTime = "";

	                	if(hourRegExp.test(timeTokens[0])) {
	                		formattedTime += timeTokens[0];
	                	} else {
	                		formattedTime += prevTimeTokens[0];
	                	}

	                	if(timeTokens[1] === "" && prevTimeTokens[1] === ":" && timeTokens[2] === "" && timeTokens[0].length <= 3
	                		|| timeTokens[1] === ":" && hourRegExp.test(timeTokens[0]) && timeTokens[0].length === 2) {
	                		formattedTime += timeTokens[1];
	                	} else {
	                		formattedTime += prevTimeTokens[1];
	                	}
	                	if(formattedTime.lastIndexOf(":") !== -1) {
		                	if(minuteRegExp.test(timeTokens[2])){
		                		formattedTime += timeTokens[2];
		                	} else {
		                		formattedTime += prevTimeTokens[2];
		                	}
	                	}

	                	if(timeTokens[3] === "" && prevTimeTokens[3] === " " && timeTokens[4] === "" && timeTokens[0].length <= 3
	                		|| timeTokens[3] === " " && minuteRegExp.test(timeTokens[2]) && timeTokens[2].length === 2) {
	                		formattedTime += timeTokens[3];
	                	} else {
	                		formattedTime += prevTimeTokens[3];
	                	}

	                	if(formattedTime.lastIndexOf(" ") !== -1) {
		                	if(periodRegExp.test(timeTokens[4])) {
		                		formattedTime += timeTokens[4];
		                	} else {
		                		formattedTime += prevTimeTokens[4];
		                	}
	                	}

	                	prevTimeTokens = tokenizeTimeString(formattedTime);
	                	scope.ngModel = formattedTime;

						if(prevTime === formattedTime && formattedTime !== "") {
							$timeout(function(){
								inputArea[0].setSelectionRange(selectionStart, selectionEnd);
							});
	                	}
					};

					scope.onKeydown = function(e) {
						selectionStart = inputArea[0].selectionStart;
						selectionEnd = inputArea[0].selectionEnd;
					};
				},
				templateUrl: 'modules/ui-components/form/controls/composite/input-time-picker/time-control_template.html'
			};
		});

	var isFormattedTime = function (timeString) {
		return /^(0[1-9]|1[0-2])\:([0-5][0-9]) ([APap][Mm])$/.test(timeString);
	};

	var futureTime = function (date, time) {
		var inputTime = new Date(date + " " + time);
		var today = new Date();
		return /^(\d{2})\:(\d{2}) (AM|PM|am|pm)$/.test(time) && inputTime.toString() !== "Invalid Date" && inputTime > today;
	};
});
