define(['app', 'angular'], function(app, angular) {
	"use strict";

	app.directive('multiPhone', function($timeout, formatter, focusService) {
		return {
			restrict: 'AE',
			require: 'ngModel',
			scope: {
				primaryLabel: "=",
				secondaryLabel: "=",
				ngModel: "=",
				typeOptions: "=",
				allowOconus: "="
			},
			link: function(scope, elem, attrs, ngModelCtrl) {
				scope.addPhone = function() {
					if (scope.ngModel.length < 5) {
						scope.ngModel.push({system: "phone", value: "", use: ""});
						$timeout(function() {
							focusService.focusElement(elem.find("input-phone:last input[type='text']"));
						});
					}
				};

				scope.deletePhone = function(index) {
					scope.ngModel.splice(index - 1, 1);
					$timeout(function() {
						focusService.focusElement(elem.find("input-phone:last input[type='text']"));
					});
				};
			},
			templateUrl: 'modules/ui-components/form/controls/composite/input-multi-phone/multi-phone_template.html'
		};
	});
});
