define(['app', 'angular'], function (app, angular) {

	app.directive('inputDateTimeRange', function ($timeout) {
		return {
			restrict: 'AE',
			require: ['ngModel', '^form'],
			scope: {
				'ngRequired': '=',
				'ngModel': '='
			},
			link: function (scope, elem, attr, ctrls) {
				var formCtrl = ctrls[1];
				var modelCtrl = ctrls[0];

				scope.errorHandling = {
					'startAfterEnd': {
						message: "Start Date/Time must occur before End Date/Time.",
						priority: 1
					}
				};
				scope.$watch("ngModel", function (newVal, oldVal) {
					$timeout(function(){
						var individuallyValid = formCtrl.startDate.$valid && formCtrl.startTime.$valid && formCtrl.endDate.$valid && formCtrl.endTime.$valid;
						var valid = new Date(newVal.startOnlyDate + " " + newVal.startOnlyTime) <= new Date(newVal.endOnlyDate + " " + newVal.endOnlyTime);
						modelCtrl.$setValidity('startAfterEnd', individuallyValid && valid || !individuallyValid);
					});
				}, true);
			},
			templateUrl: 'modules/ui-components/form/controls/composite/input-date-time/input-date-time_template.html'
		};
	});
});