define(['app', 'formatter', 'InputCalendarDatePicker'], function() {
	'use strict';

	describe("The Input Calendar Date Picker directive", function (){
		var scope,
			isolateScope,
			elm,
			element,
			timeout;

		beforeEach(function () {
			module('angularTemplateApp');
			module('InputCalendarDatePicker');
			inject(function($templateCache) {
				$templateCache.put('modules/ui-components/form/controls/composite/input-calendar-date-picker/input-calendar-date-picker_template.html', '<input />');
				$templateCache.put('modules/ui-components/form/controls/composite/input-calendar-date-picker/input-calendar-date-picker-popup_template.html', '<div></div>');
			});
		});

		describe('the directive', function () {
			beforeEach(function () {
				inject(function($rootScope, $compile, $timeout) {
					scope = $rootScope;
					timeout = $timeout;

					elm = "<date-control label='Date Label' ng-model='scope.value' is-sub-label='true' ng-disabled='false' ng-readonly='false' ng-required='false'></date-control>";
					element = $compile(elm)(scope);
					scope.$digest();

					isolateScope = element.isolateScope();
				});
			});

			it('should have isolateScope variables defined', function () {
				expect(isolateScope.label).toEqual("Date Label");
				expect(isolateScope.isSubLabel).toEqual('true');
				expect(isolateScope.ngDisabled).toEqual(false);
				expect(isolateScope.ngRequired).toEqual(false);
				expect(isolateScope.ngReadonly).toEqual(false);
			});
		});
	});
});
