define(['app', 'angular'], function (app, angular) {

	app.directive('filterWrapper', function () {
		return {
			restrict: 'AE',
			require: 'ngModel',
			transclude: true,
			scope: {
				ngModel: '=',
				service: '=',
				disableFilter: '=',
				defaultFilters: '=',
				callbacks: '=',
				noFocus: '=',
				focusSelector: '='
			},
			link : function(scope, elem, attr){
				scope.requiredExists = function(){
					return elem.find(":input[required]").length > 0;
				};
			},
			controller: function($scope, $q, focusService) {
				$scope.ngModel = angular.copy($scope.service.dataPointers ? ($scope.service.dataPointers.filters || $scope.defaultFilters) : $scope.defaultFilters);

				$scope.filter = function() {
					var defer = $q.defer();

					$scope.filterForm.validationSummary.validate().then(function(){
						$scope.ngModel.displayStatus = $scope.ngModel.status ? $scope.ngModel.status : '';
						$scope.service.fetch($scope.ngModel).then(function(data){
							defer.resolve(data);
							if($scope.callbacks) $scope.callbacks();
							if(!$scope.noFocus) {
								var focusElement = $scope.focusSelector || ((($scope.service.dataPointers.list || {}).length === 0 ? ".no-results-message" : "li[role='button']") + "[tabindex]");
			                	focusService.focusElement(focusElement, true);
			            	}
						});
					});

					return defer.promise;
				};

				$scope.reset = function() {
					$scope.ngModel = angular.copy($scope.defaultFilters);
					$scope.filter().then(function(data){
		                $scope.callbacks && $scope.callbacks.reset && $scope.callbacks.reset($scope.service.dataPointers.list);
					});
				};
			},
			templateUrl: 'modules/ui-components/filter/filter-wrapper_template.html'
		};
	});

});