define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.directive('accessibleCarousel', function($timeout, focusService){
		return {
			controller: 'AccessibleCarouselController',
			link:function(scope, elem, attr){

				$timeout(function(){
					var carousel = elem.find('div');//[1];
					var carouselCtrl = angular.element(carousel).isolateScope();
					var currIndex = carouselCtrl.getCurrentIndex;

					var origNext = carouselCtrl.next;
					carouselCtrl.next = function(){
						if(scope.interceptNext()){
							origNext();
							$timeout(function() {
								var index = currIndex();
								focusService.focusElement('#carouselImg'+index, true);
							}, 600);
						}
					};
					var origPrev = carouselCtrl.prev;
					carouselCtrl.prev = function(){
						if(scope.interceptNext()){
							origPrev();
							$timeout(function() {
								var index = currIndex();
								focusService.focusElement('#carouselImg'+index, true);
							}, 600);
						}
					};
				});
			}
		};
	});
});
