define(['angular', 'text!../app-links.json'], function (angular, appLinksJson) {
    "use strict";

    angular.module('AppLinksModule', [])
        .controller('AppLinksController', function ($scope) {
            var appLinksParsed = JSON.parse(appLinksJson);

            $scope.links = appLinksParsed.links || [];
        })
        .directive('appLinks', function () {
            return {
                restrict: 'AC',
                controller: 'AppLinksController',
                templateUrl: 'modules/ui-components/app-links/app-links_template.html'
            }
        })
        .filter('titleToId', function () {
          return function(title) {
            return title.toLowerCase().replace(/\s/g, "-");
          };
        });
});
