define(['SrAlert'], function () {
    'use strict';

    describe('SrAlert directive', function () {
        var scope,
            isolatedScope,
            compile,
            element,
            timeoutMock,
            timeoutCallback;

        beforeEach(function () {
            module('angularTemplateApp');

            timeoutMock = jasmine.createSpyObj('timeoutMock', ['$timeout']);

            timeoutMock.$timeout.and.callFake(function (callback, time) {
                timeoutCallback = callback;
            });

            module(function ($provide) {
                $provide.value('$timeout', timeoutMock.$timeout);
            });

            inject(function ($compile, $rootScope, $templateCache) {
                var directive = angular.element('<sr-alert message="message" />'),
                    template = '<p class="sr-only" aria-live="assertive">{{activeMessage}}</p>';

                compile = $compile;

                scope = $rootScope.$new();

                $templateCache.put('modules/ui-components/accessibility/sr-alert/sr-alert_template.html', template);

                scope.message = '';

                element = $compile(directive)(scope);
                scope.$digest();

                isolatedScope = element.isolateScope();
            });
        });

        it('should initially set activeMessage to an empty string', function () {
            expect(isolatedScope.activeMessage).toEqual('');
        });

        it('should set ariaLive to "assertive" if not already set', function () {
            expect(isolatedScope.ariaLive).toEqual('assertive');
        });

        it('should respect the previously set value for ariaLive', function () {
            isolatedScope.ariaLive = 'polite';

            scope.$digest();

            expect(isolatedScope.ariaLive).toEqual('polite');
        });

        it('should update activeMessage when message is updated', function () {
            isolatedScope.message = 'Some message';

            scope.$digest();

            expect(isolatedScope.activeMessage).toEqual('Some message');
        });

        it('should reset activeMessage after 2000ms when message is updated', function () {
            isolatedScope.message = 'Some message';

            scope.$digest();

            expect(isolatedScope.activeMessage).toEqual('Some message');

            expect(timeoutMock.$timeout.calls.argsFor(0)[1]).toEqual(2000);

            timeoutCallback();

            expect(isolatedScope.activeMessage).toEqual('');
        });
    });
});
