define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.directive('srAlert', function ($timeout) {
        return {
            restrict: 'E',
            scope: {
                'message': '=',
                'ariaLive': '@'
            },
            templateUrl: 'modules/ui-components/accessibility/sr-alert/sr-alert_template.html',
            link: function (scope, elem, attrs) {
                scope.activeMessage = '';
                scope.ariaLive = scope.ariaLive || 'assertive';

                scope.$watch('message', function () {
                    scope.activeMessage = scope.message;

                    $timeout(function () {
                        scope.activeMessage = '';
                    }, 2000);
                });
            }
        };
    });
});