define(['app', 'angular'], function (app, angular) {
	"use strict";

	app.directive('ariaHidden', function () {
		return {
			restrict: 'A',
			link:function(scope, elem, attrs) {
				if(!elem.hasClass("icon")) {
					scope.$watch(function(){
						return elem.attr("aria-hidden");
					}, function(newVal, oldVal){
						if (newVal === "true" && oldVal === "false"){
							elem.find("[tabindex='0']").attr("data-tab", "0").removeAttr("tabindex");
							elem.find("[href], input, select, textarea, button").filter(":not([tabindex])").attr("tabindex", "-1");
						} else if (newVal === "false" && oldVal === "true"){
							elem.find("[data-tab='0']").attr("tabindex", '0').removeAttr("data-tab");
							elem.find("[href], input, select, textarea, button").filter(":not([data-tab]):not([ng-click='openCalendarPopup($event)'])").removeAttr("tabindex");
						}
					});
				}
			}
		};
	});
});
