define([
		'app',
		'local-storage_service',
		'session-storage_service',
		'authentication_service',
		'mhpuser_service',
		'userSessionService',
		'localResourceDirectoryService',
		'fhirPatientService',
		'fhirResources',
		'patient',
		'connection_error_service',
		'connection_timeout_service',
		'modalService',
		'progressService',
		'submitEvaluationService',
		'EulaController',
		'HeaderController',
		'FooterController',
		'MainController',
		'HelpController',
		'AboutController',
		'TourController',
		'accessibleDatePickerServices',
		'HomeModule',
		'MyTeledermModule',
		'MyVideoModule',
		'SecondaryNavigationController',
		'consentService',
		'questionnaireService',
		'questionnaireResponseService'

	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, unsavedWarningsConfigProvider) {

			$stateProvider
				.state('main', {
					abstract: true,
					data: {
						appletName: "My VA Images",
						requiresAuth: true
					},
					views: {
						"": {
							templateUrl: 'modules/container/main/main_template.html',
							controller: 'MainController'
						},
						'header@main': {
							templateUrl: 'modules/container/components/header/header_template.html',
							controller: 'HeaderController'
						},
						'footer@main': {
							templateUrl: 'modules/container/components/footer/footer_template.html',
							controller: 'FooterController'
						}
					}
				})
				.state('main.two-panel', {
					abstract: true,
					templateUrl: 'modules/container/components/content/two-column_template.html',
					controller: 'TwoPanelController'
				})
				.state('main.two-panel.secondary-navigation', {
					abstract: true,
					views : {
						'secondary@main.two-panel' : {
							templateUrl: "modules/container/components/content/secondary-navigation/secondary-navigation_template.html",
							controller: "SecondaryNavigationController"
						}
					}
				})
				.state('main.consent', {
					 views: {
						"": {
							templateUrl: 'modules/container/components/content/single-column_template.html'
						},
						'primary@main.consent': {
							templateUrl: 'modules/applets/shared/pages/consent/consent_template.html',
							controller: 'ConsentController'
						}
					},
					params: { routeBase: null }
				})
				.state('eula', {
					url: '/eula',
					data: {
						appletName: "My VA Images",
						requiresAuth: false
					},
					templateUrl: 'modules/core/eula/eula_template.html',
					controller: 'EulaController'
				});

			unsavedWarningsConfigProvider.useTranslateService = false;
		});

		app.run(function ($rootScope, $state, $timeout, authenticationService, userSessionService, pageService, connectionErrorService, localResourceDirectoryService, consentService) {

			connectionErrorService.run();

			$rootScope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
				if (typeof authenticationService.isAuthenticated() !== 'boolean') {
					authenticationService.init();
				}

				if(toState.data.requiresAuth) {
					authenticationService.checkAuthStatus().finally(function () {
						if (authenticationService.isAuthenticated()) {
							userSessionService.fetch().then(function (user) {
								if ((toState.name.indexOf('mytelederm') !== -1) || (toState.name.indexOf('myvideo') !== -1)) {
									if (consentService.showConsent(user)) {
										redirectToState(event, toState, toParams, 'main.consent');
									}
								}
							});
						} else {
							redirectToState(event, toState, toParams, 'main.landing');
						}
					});
				} else {
					$state.go(stateName, toParams);
				}
			});

			function redirectToState(event, toState, toParams, stateName) {
				if (toState.name !== stateName) {
					event.preventDefault();
					toParams = toParams || {}
					toParams.routeBase = toState.name;
					$state.go(stateName, toParams);
				}
			}
		});
	});
