define(['app', 'angular'], function (app, angular) {
	'use strict';

	app.config(function ($provide) {
		$provide.decorator('collapseDirective', function($delegate, $timeout) {
		   	var original = $delegate[0];

		    original.compile = function() {
		      return function(scope, element, attrs) {
		        original.link.apply(this, arguments);
		        scope.$watch(attrs.collapse, function(newVal){
		        	$timeout(function(){
		        		attrs.$set("aria-hidden", newVal);
		        	});
		        });
		      };
		    };
			return $delegate;
		});
	});
});