define(['localStorageService'], function () {
	'use strict';

	describe('Local Storage Service', function () {
		var $scope,
			service,
			mhpUserMock,
			storage = {};

		beforeEach(function() {
			module('angularTemplateApp');

			mhpUserMock = jasmine.createSpyObj('mhpuser', ['warnLaunchpadNotInstalled']);

			spyOn(localStorage, 'getItem').and.callFake(function (key) {
				return storage[key];
			});

			spyOn(localStorage, 'setItem').and.callFake(function (key, value) {
				storage[key] = value;
			});
			
			module(function($provide) {
				$provide.value('mhpuser', mhpUserMock);
			});

			inject(function(localStorageService) {
				service = localStorageService;
			});
		});

		describe('the service', function () {
			
			it('should be able encrypt the user ID', function () {
				var userId = '12345';
				var encrpytedId = service.encrypt(userId);
				expect(encrpytedId).toEqual('38|39|40|41|42');
			});

			it('should add a key to the service', function () {
				service.showModal({
					id: '12345'
				}, 'newKey');

				expect(service.keys['newKey']).toEqual('myvaimages/38|39|40|41|42/newKey');
			});

			it('should return show modal true if local storage not set', function () {
				spyOn(service, 'encrypt').and.returnValue('');

				var showNotice = service.showModal({id:1},'no-show-notice');
				expect(showNotice).toEqual(true);

				var showCarousel = service.showModal({id:1},'no-show-carousel');
				expect(showCarousel).toEqual(true);

				var showNavigationTips = service.showModal({id:1},'no-show-navigation-tips');
				expect(showNavigationTips).toEqual(true);
			});

			it('should return show carousel true even if accepted is set', function () {
				spyOn(service, 'encrypt').and.returnValue('');
				service.accepted = true;
				var showCarousel = service.showModal({id:1},'no-show-carousel');
				expect(showCarousel).toEqual(true);
			});

			it('should return show notice false if local storage is set', function () {
				spyOn(service, 'encrypt').and.returnValue('');
				var key = 'myvaimages//no-show-notice';
				localStorage.setItem(key, true);
				var showNotice = service.showModal({id:1},'no-show-notice');
				expect(showNotice).toEqual(false);
			});

			it('should return show carousel false if local storage is set', function () {
				spyOn(service, 'encrypt').and.returnValue('');
				var key = 'myvaimages//no-show-carousel';
				localStorage.setItem(key, true);
				var showCarousel = service.showModal({id:1},'no-show-carousel');
				expect(showCarousel).toEqual(false);
			});

			it('should return show navigation tips false if local storage is set', function () {
				spyOn(service, 'encrypt').and.returnValue('');
				var key = 'myvaimages//no-show-navigation-tips';
				localStorage.setItem(key, true);
				var showNavigationTips = service.showModal({id:1},'no-show-navigation-tips');
				expect(showNavigationTips).toEqual(false);
			});
		});
	});
});