define(['angular', 'app', 'moment', 'appConfig'], function (angular, app, moment) {
	"use strict";
	app.service("formatter",
		function ($rootScope, $filter, config) {

			var formatter = {};

			formatter.getFormattedFrontendMonthYear = function(dateString){
				if(!dateString) {
					return "";
				}

				var date = new Date(dateString);
				if(date.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(date, config.formats.FRONTEND.MONTH_YEAR);
			};


			formatter.getFormattedFrontendDate = function(dateString){
				if(!dateString) {
					return "";
				}

				if(!(dateString instanceof Date) && dateString.indexOf(':') < 0 && dateString.indexOf('-') === 4) //limit to just YYYY-DD-MM format from backend
					dateString = dateString + "T12:00:00";

				var date = new Date(dateString);
				if(date.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(date, config.formats.FRONTEND.DATE);
			};

			formatter.getFormattedFrontendTime = function(timeString){
				if(!timeString) {
					return "";
				}

				var date = new Date(timeString);
				if(date.toString() === "Invalid Date") {
					date = new Date("12/12/1212 " + timeString);
				}

				return $filter('date')(date, config.formats.FRONTEND.TIME);
			};

			formatter.getFormattedFrontendDateTime = function(dateTimeString){
				if(!dateTimeString) {
					return "";
				}

				var dateTime = new Date(dateTimeString);
				if(dateTime.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(dateTime, config.formats.FRONTEND.DATE_TIME);
			};

			formatter.getFormattedBackendDate = function(dateString){
				if(!dateString) {
					return "";
				}

				if(!(dateString instanceof Date) && dateString.indexOf(':') < 0)
					dateString = dateString + " 12:00:00";

				var date = new Date(dateString);
				if(date.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(date, config.formats.BACKEND.DATE);
			};

			formatter.getFormattedBackendTime = function(timeString){
				if(!timeString) {
					return "";
				}

				var date = new Date(timeString);
				if(date.toString() === "Invalid Date") {
					date = new Date("12/12/1212 " + timeString);
				}

				return $filter('date')(date, config.formats.BACKEND.TIME);
			};

			formatter.getFormattedBackendDateTime = function(dateTimeString){
				if(!dateTimeString) {
					return "";
				}
				
				var dateTime = new Date(dateTimeString);
				if(dateTime.toString() === "Invalid Date") {
					return null;
				}
				var filterDate = $filter('date')(dateTime, config.formats.BACKEND.DATE_TIME);

				//insert colon into timezone info as required by HL7 standard https://www.hl7.org/fhir/datatypes.html#dateTime
				filterDate = filterDate.slice(0, filterDate.length - 2) + ":" + filterDate.slice(filterDate.length - 2);

				return filterDate;
			};

			formatter.getDateTimeMinusDelta = function(date, delta, format){
				date = new Date(date);
				var months = delta.months || 0;
				var days = delta.days || 0;
				var years = delta.years || 0;
				var hours = delta.hours || 0;
				var minutes = delta.minutes || 0;
				var seconds = delta.seconds || 0;
				var milliseconds = delta.milliseconds || 0;
				date = new Date(date.getFullYear()+years, date.getMonth()+months, date.getDate()+days,
					date.getHours()+hours, date.getMinutes()+minutes, date.getSeconds()+seconds, date.getMilliseconds()+milliseconds);
				
				if(format ==="front") {
					return formatter.getFormattedFrontendDateTime(date);
				} else {
					return formatter.getFormattedBackendDateTime(date)
				}
			};

			formatter.getDateRangeFromStartDate = function(startDate, delta){
				var endDate = formatter.getDateTimeMinusDelta(startDate, delta, "front");
				return {
					startDate : formatter.getFormattedFrontendDate(startDate),
					endDate : formatter.getFormattedFrontendDate(endDate)
				};
			};

			formatter.getDateRangeFromEndDate = function(endDate, delta){
				delta = angular.copy(delta);
				for(var key in delta) {
					if(delta.hasOwnProperty(key)) {
						delta[key] = -1 * delta[key];
					}
				}

				var startDate = formatter.getDateTimeMinusDelta(endDate, delta, "front");

				return {
					startDate : formatter.getFormattedFrontendDate(startDate),
					endDate : formatter.getFormattedFrontendDate(endDate)
				};
			};

			formatter.getDefaultDateRange = function(){
				var startDate = new Date();
				return formatter.getDateRangeFromEndDate(startDate, config.defaults.DATE_RANGE_DELTA);
			};

			formatter.addDays = function(date, days) {
				var dat = new Date(date.valueOf());
				dat.setDate(dat.getDate() + days);
				return dat;
			}

			formatter.dotifyArrayOfPrimatives = function(array){
				return array.map(function(item){
					return {value : item};
				});
			};

			formatter.undotifyArrayOfPrimatives = function(array){
				return array.map(function(item){
					return item.value;
				});
			};

			formatter.getNthBirthday = function (dob, years) {
				var dobMoment = moment(dob);

				return dobMoment.add(years, 'Y');
			};
			
			formatter.base64toBlob = function(rawBase64Data) {
				// convert base64 to raw binary data held in a string
				var byteString = atob(rawBase64Data.split(',')[1]);

				// separate out the mime component
				var mimeString = rawBase64Data.split(',')[0].split(':')[1].split(';')[0];

				// write the bytes of the string to an ArrayBuffer
				var arrayBuffer = new ArrayBuffer(byteString.length);
				var _ia = new Uint8Array(arrayBuffer);
				for (var i = 0; i < byteString.length; i++) {
					_ia[i] = byteString.charCodeAt(i);
				}

                var dataView = new DataView(arrayBuffer);

                // fix for InvalidStateError in internet explorer 11
                try {
                    var blob = new Blob([dataView], { type: mimeString });
                }
                catch (e) {
                    window.BlobBuilder = window.BlobBuilder ||
                                         window.webKitBlobBuilder ||
                                         window.MozBlobBuilder ||
                                         window.MSBlobBuilder;
                    if (window.BlobBuilder) {
                        var bb = new BlobBuilder();
                            bb.append(arrayBuffer);
                            blob = bb.getBlob(mimeString);
                    }
                }

				return blob;
			};

			formatter.toTitleCase = function(word) {
				return word[0].toUpperCase() + word.slice(1).toLowerCase();
			};

			return formatter;
		
		});
});