define(['focusManager'], function() {
	'use strict';
	describe('Focus Service and Directive', function () {
		var rootScope,
			service;

		beforeEach(function () {
			module('angularTemplateApp');
			module('focusManager');

			inject(function($rootScope, focusService) {
				rootScope = $rootScope;
				service = focusService;
			});
		});

		describe('the focus service', function () {

			beforeEach(function () {
				spyOn(rootScope, '$emit').and.callThrough();
			});

			it('should have basic focus functions that emit events', function () {
				expect(service.focusMain).toBeDefined();
				expect(service.focusPrimary).toBeDefined();
				expect(service.focusSecondary).toBeDefined();
				expect(service.focusTopModal).toBeDefined();
				expect(service.focusElement).toBeDefined();

				service.focusMain();
				expect(rootScope.$emit).toHaveBeenCalledWith('focusMain');

				service.focusPrimary();
				expect(rootScope.$emit).toHaveBeenCalledWith('focusPrimary');
				
				service.focusSecondary();
				expect(rootScope.$emit).toHaveBeenCalledWith('focusSecondary');
			});
		});

		describe('the focus directive', function () {
			var rootScope,
				compile,
				timeout;

			beforeEach(function () {
				// re-init rootScope for directive instead of service
				inject(function($rootScope, $timeout, $compile) {
					rootScope = $rootScope;
					timeout = $timeout;
					compile = $compile;
				});

				spyOn(rootScope, '$on').and.callThrough();
				spyOn(service, 'focusElement').and.callThrough();
			});

			it('should focus on elements with main-focus directive', function () {
				var element = compile("<h2 main-focus>Test</h2>")(rootScope);
				rootScope.$digest();
				spyOn(element[0], 'focus');
				spyOn(element[0], 'blur');

				service.focusMain();
				
				timeout.flush();
				timeout.flush();
				
				expect(rootScope.$on).toHaveBeenCalled();

				// Testing focusElement() here, won't repeat all the checks in other 'it-blocks'
				expect(service.focusElement).toHaveBeenCalled();
				expect(element[0].focus).toHaveBeenCalled();
				expect(element[0].blur).toHaveBeenCalled();
			});
			
			it('should focus on elements with primary-focus directive', function () {
				var element = compile("<h2 primary-focus>Test</h2>")(rootScope);
				rootScope.$digest();
				spyOn(element[0], 'focus');
				spyOn(element[0], 'blur');

				service.focusPrimary();
				
				timeout.flush();
				
				expect(rootScope.$on).toHaveBeenCalled();
				expect(service.focusElement).toHaveBeenCalled();
			});
			
			it('should focus on elements with secondary-focus directive', function () {
				var element = compile("<h2 secondary-focus>Test</h2>")(rootScope);
				rootScope.$digest();
				spyOn(element[0], 'focus');
				spyOn(element[0], 'blur');

				service.focusSecondary();
				
				timeout.flush();
				
				expect(rootScope.$on).toHaveBeenCalled();
				expect(service.focusElement).toHaveBeenCalled();
			});

		});
	});
});