define(['fileValidationService'], function () {
	'use strict';

	describe('File Validation Service', function () {
		var $scope,
			service;

		beforeEach(function() {
			module('angularTemplateApp');

			inject(function(fileValidationService) {
				service = fileValidationService;
			});
		});

		describe('validateFileSize function', function () {
			it('validateFileSize should return false if filesize is greater than allowed', function () {
                var fileObj = {size: 100};
                var fileSizeValid = service.validateFileSize(fileObj, 50);
				expect(fileSizeValid).toBeFalsy();
            });
            
            it('validateFileSize should return true if filesize is less than allowed', function () {
                var fileObj = {size: 50};
                var fileSizeValid = service.validateFileSize(fileObj, 100);
				expect(fileSizeValid).toBeTruthy();
            });
            
            it('validateFileSize should return true if filesize is equal to allowed', function () {
                var fileObj = {size: 50};
                var fileSizeValid = service.validateFileSize(fileObj, 50);
				expect(fileSizeValid).toBeTruthy();
			});
        });

        describe('validateFileType function', function () {
			it('validateFileType should return false if file extension is not allowed', function () {
                var fileTypes = ['test1', 'test2'];
                var fileName = 'test.abc';
                var fileTypeValid = service.validateFileType(fileName, fileTypes);
				expect(fileTypeValid).toBeFalsy();
            });
            
            it('validateFileType should return true if file extension is allowed', function () {
                var fileTypes = ['abc'];
                var fileName = 'test.abc';
                var fileTypeValid = service.validateFileType(fileName, fileTypes);
				expect(fileTypeValid).toBeTruthy();
            });

            it('validateFileType should return true if file extension is allowed and filename is all caps', function () {
                var fileTypes = ['abc'];
                var fileName = 'TEST.ABC';
                var fileTypeValid = service.validateFileType(fileName, fileTypes);
				expect(fileTypeValid).toBeTruthy();
            });
        });
        
        describe("getFileExtension function", function () {
            it('should return the file extension of a simple filename', function () {
                expect(service.getFileExtension('file.jpg')).toEqual('jpg');
            });

            it('should return the file extension of a complex filename', function () {
                expect(service.getFileExtension('~/Documents/my.folder/my.file.jpg')).toEqual('jpg');
            });

            it('should return an empty string if there is no file extension', function () {
                expect(service.getFileExtension('file')).toEqual('');
            });

            it('should return an empty string if an empty string was passed in', function () {
                expect(service.getFileExtension('')).toEqual('');
            });
        });
	});
});