define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('fileValidationService', function () {
		return {
            validateFileSize: function (fileObj, maxFileSize) {
                var fileSize = fileObj ? fileObj.size : 0;
                
                if (fileSize > maxFileSize) {
                    return false;
                }

                return true;
			},
			validateFileType: function (fileName, allowableFileExtensions) {
				if (allowableFileExtensions.indexOf(this.getFileExtension(fileName).toLowerCase()) === -1) {
                    return false;
                }

                return true;
            },
            getFileExtension: function (fileName) {
                var fileNameParts = fileName.split('.');
    
                return fileNameParts.length > 1 ? fileNameParts[fileNameParts.length - 1] : '';
            }
		};
	});
});
