define(['authentication_service'], function () {
	'use strict';

	describe('Authentication Service --', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			$window,
			$location,
			$injector,
			service,
			localDeferred,
			pageServiceMock,
			connectionTimeoutServiceMock,
			windowOpenSpy;

		beforeEach(function() {
			module('angularTemplateApp');


			pageServiceMock = jasmine.createSpyObj('pageService', ['warnLaunchpadNotInstalled']);
			connectionTimeoutServiceMock = jasmine.createSpyObj('connectionTimeoutService', ['run']);

			module(function($provide) {
				$provide.value('pageService', pageServiceMock);
				$provide.value('connectionTimeoutService', connectionTimeoutServiceMock);
			});

			inject(function($rootScope, _$http_, _$httpBackend_, _$q_, _$window_, _$location_, _$injector_, authenticationService) {
				$scope = $rootScope;
				$http = _$http_;
				$httpBackend = _$httpBackend_;
				$q = _$q_;
				$window = _$window_;
				$location = _$location_;
				$injector = _$injector_;
				service = authenticationService;
			});
		});

		describe('the service', function () {
			beforeEach(function () {
				windowOpenSpy = spyOn(window, 'open');
				sessionStorage.setItem('token', null);

				localDeferred = $q.defer();
				localDeferred.resolve('success'); // general resolved/success promise
			});

			it('should have some commonly used methods defined', function () {
				expect(service.authorize).toBeDefined();
				expect(service.authenticate).toBeDefined();
				expect(service.isAuthenticated).toBeDefined();
			});

			it('should be able to delete cookie', function () {
				var testCookie = 'fakeCookie=12345';
				document.cookie = testCookie;
				expect(document.cookie).toEqual(testCookie);
				service.deleteCookie('fakeCookie');				
				expect(document.cookie).toEqual('');
			});

			it('should wipe session data', function () {
				spyOn(service, 'deleteCookie').and.callThrough();

				service.wipeSessionData();

				$scope.$digest();

				expect(service.deleteCookie).toHaveBeenCalled();
			});

			it('should login with redirect', function () {
				spyOn(service, 'wipeSessionData').and.returnValue(localDeferred.promise);
				service.gotoLoginWithRedirect('fakeUrl');

				$scope.$digest();

				expect(service.wipeSessionData).toHaveBeenCalled();
			});

			it('should logout with redirect', function () {
				spyOn(service, 'wipeSessionData').and.returnValue(localDeferred.promise);
				service.gotoLogoutWithRedirect('fakeUrl');

				$scope.$digest();

				expect(window.open).toHaveBeenCalled();
				expect(service.wipeSessionData).toHaveBeenCalled();
			});

			it('should logout and redirect to Launchpad', function () {
				spyOn(service, 'wipeSessionData').and.callThrough();
				service.logoutRedirectToLaunchpad();

				$scope.$digest();

				expect(service.wipeSessionData).toHaveBeenCalled();
			});

			it('should authorize a user', function () {
				spyOn(service, 'gotoLoginWithRedirect');

				service.authorize();
				$scope.$digest();
			});

			it('should authenticate users', function () {
				spyOn(service, 'checkAuthStatus').and.returnValue(
					{
						then: function (callback) {
							callback(true);
						}
					}
				);
                service.authenticate();
				$scope.$digest();

				// there is funkiness within service.authenticate() (related to window.cordova), won't test deeply
				expect(service.checkAuthStatus).toHaveBeenCalled();
			});
		});

		describe('checkAuthStatus Function', function () {

			it('shouldnt run connection timeout if not authenticated', function () {
				service.setUser({authenticated:false});
				service.checkAuthStatus();
				expect(connectionTimeoutServiceMock.run).not.toHaveBeenCalled();
			});

			it('should run connection timeout if authenticated', function () {
				service.setUser({authenticated:true});
				service.checkAuthStatus();
				expect(connectionTimeoutServiceMock.run).toHaveBeenCalled();
			});
		});
	});
});