define(['angular', 'app', 'global'], function (angular, app) {
	"use strict";
	app.service('authenticationService',
		function ($http, $q, $window, $location, $injector, pageService) {
			var _auth = {};
			var isAuthenticated;
			var user = null;
			var jwt = null;
			var loginBaseUrl = "/users/v1/login?scope=VETERAN";
			var logoutBaseUrl = "/users/v1/logout";
			var sessionBaseUrl = "/users/v1/session/";

			_auth.init = function () {
				_auth.checkJwt();
			};

			_auth.checkJwt = function(){
				jwt = _auth.getJwtFromCookie("vamfjwtv1");
				user = jwt === '' ? {} : _auth.parseJwt(jwt);
			};

			_auth.getJwtFromCookie = function (a) {
				var b = document.cookie.match('(^|;)\\s*' + a + '\\s*=\\s*([^;]+)');
				return b ? b.pop() : '';
			};
			_auth.parseJwt = function (token) {
				var base64String = token.split('.')[1];
				var base64 = base64String.split('-').join('+').split('_').join('/');
				return JSON.parse(window.atob(base64));
			};

			_auth.deleteCookie = function (cookieName) {
				document.cookie = encodeURIComponent(cookieName) + '=deleted; expires=' + new Date(0).toUTCString();
			};

			_auth.wipeSessionData = function () {
				isAuthenticated = false;
				_auth.deleteCookie("vamfjwtv1");
				sessionStorage.clear();
			};

			_auth.gotoLoginWithRedirect = function (url) {
				_auth.wipeSessionData();
				window.open(url + "&redirect_uri=/myvaimages/", "_self");
			};

			_auth.gotoLogoutWithRedirect = function () {
                _auth.wipeSessionData();
                window.open(logoutBaseUrl, "_self");
			};

			_auth.logoutRedirectToLaunchpad = function () {
				_auth.wipeSessionData();
				if (window.cordova) {
					pList.fetch(function (pList) {
						var launchpadUrl = pList["LaunchpadCustomUrlScheme"] + "://";

						AppLauncher.isAppAvailable(function () {
								nativeAuth.deauthorize(launchpadUrl);
							}, function () {
								pageService.warnLaunchpadNotInstalled('logout');
							},
							launchpadUrl
						);
					});
				} else {
					window.open(logoutBaseUrl + "?" + new Date().getTime() + "&redirect_uri=/launchpad/", "_self");
				}
			};

			_auth.getCurrentToken = function () {
				return jwt;
			};

			_auth.authorize = function () {
				_auth.gotoLoginWithRedirect(loginBaseUrl);
			};

			_auth.authenticate = function () {
				var deferred = $q.defer();

				_auth.checkAuthStatus().then(function (userAuthenticated) {
					if (userAuthenticated) {
						deferred.resolve(userAuthenticated);
					} else {
						if (window.cordova) {
							nativeAuth.authorize(
								function () {
									window.location.reload();
								},
								function () {
									deferred.reject(userAuthenticated);
								});
						} else {
							_auth.gotoLoginWithRedirect(loginBaseUrl);
							deferred.reject(userAuthenticated);
						}
					}
				});

				return deferred.promise;
			};

			_auth.isAuthenticated = function () {
				return isAuthenticated;
			};

			_auth.setUser = function (userObj) {
				user = userObj ;
			};

			_auth.checkAuthStatus = function () {
				var deferred = $q.defer();

				isAuthenticated = user.authenticated;
				if (isAuthenticated) {
					$injector.invoke(['connectionTimeoutService', function (connectionTimeoutService) {
						connectionTimeoutService.run();
					}]);
				}

				deferred.resolve(isAuthenticated);

				return deferred.promise;
			};

			return _auth;
		});
});