define(['angular', 'app', 'authentication_service'], function (angular, app) {
	"use strict";
	app.service('userSessionService', function ($http, $q, authenticationService) {

		var userSession = {};
		var isReady;
		var userSessionUrl = "/users/v1/session/";

		userSession.fetch = function () {
			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			authenticationService.checkAuthStatus().then(function(){
				$http.get(userSessionUrl).success(function(user){
					isReady.resolve(user);
				}).error(function(error){
					isReady.reject(error);
					isReady = null;
				});
			});

			return isReady.promise;
		};

		return userSession;
	});
});