define(['angular', 'app', 'userSessionService', 'authentication_service'], function (angular, app) {
	"use strict";
	app.service('patient', function ($http, $q, mhpuser, userSessionService) {

		var patient = {},
			isReady;

		patient.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			userSessionService.fetch().then(
				function(user) {
					isReady.resolve(user.patient);
				},
				function(error) {
					isReady.reject(error);
					isReady = null;
				}
			);

			return isReady.promise;
		};

		return patient;
	});
});



