define(['angular', 'app', 'authentication_service', 'userSessionService'], function (angular, app) {
	"use strict";
	app.service('mhpuser', function ($http, $q, authenticationService, userSessionService) {

		var mhpUser = {};
		var isReady;

		mhpUser.fetch = function () {
			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			userSessionService.fetch().then(
				function(user) {
					isReady.resolve(user.mhpUser);
				},
				function(error) {
					isReady.reject(error);
					isReady = null;
				}
			);

			return isReady.promise;
		};

		return mhpUser;
	});
});