define(['angular', 'app', 'authentication_service'], function (angular, app) {
	"use strict";
	app.service('localResourceDirectoryService', function ($http, $q, patient, authenticationService) {
		var directory = {},
			isReady;

		directory.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			authenticationService.checkAuthStatus().then(function() {
				$q.all({patient: patient.fetch(), resources: $http.get("resources.json")})
					.then(function(responses) {
						var patient = responses.patient;
						var resources = responses.resources.data;

						//determine unique ID and assigning authority based on available fields
						var assigningAuthority, patientId;
						if(patient['icn']){
							assigningAuthority = 'ICN';
							patientId = patient['icn'];
						}
						else if(patient['edipid']){
							assigningAuthority = 'EDIPI';
							patientId = patient['edipid'];
						}

						resources.link.forEach(function(link) {
							directory[link.title] = link.href.replace("{ASSIGNING_AUTHORITY}", assigningAuthority).replace('{UNIQUE_ID}', patientId);
						});
						isReady.resolve(directory);
					}, function(error) {
						isReady.reject(error);
						isReady = null;
					});
			});

			return isReady.promise;

		};

		return directory;
	});
});