define(['angular', 'app', 'localResourceDirectoryService'], function (angular, app) {
	"use strict";
	app.service('configValuesService', function ($http, $q, localResourceDirectoryService) {

		var configServiceValues = {};
		var isReadyMap = {};

		configServiceValues.fetch = function (valueToFetch) {
			if (isReadyMap[valueToFetch]) {
				return isReadyMap[valueToFetch].promise;
			}

            isReadyMap[valueToFetch] = $q.defer();
            
            localResourceDirectoryService.fetch().then(function (resourceLinks) {
                var configServiceUrl = resourceLinks['config-service-base'] + valueToFetch;
                
                $http.get(configServiceUrl).success(function (fetchedValue) {
                    isReadyMap[valueToFetch].resolve(JSON.parse(fetchedValue.value));
                }).error(function (error) {
                    isReadyMap[valueToFetch].reject(error);
                    isReadyMap[valueToFetch] = null;
                });
            });

			return isReadyMap[valueToFetch].promise;
		};

		return configServiceValues;
	});
});