define(['angular', 'angularMocks', 'EulaController', 'angularUiRouter'], function(angular, mocks) {
    'use strict';

    describe("The Eula controller", function (){
        var controller,
            scope,
            state,
            httpMock,
            pageServiceMock;

        beforeEach( function () {
            module('angularTemplateApp');

            pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
            httpMock = jasmine.createSpyObj('$http', ['get']);
            httpMock.get.and.returnValue({
                then: function (callback) {
                    callback({
                        'data':{'agreement': 'eulaContent'}
                    });
                }
            });
            module(function($provide){
                $provide.value('pageService', pageServiceMock);
                $provide.value('$http', httpMock);
            });

            inject(function($controller, $rootScope, $state) {
                scope = $rootScope.$new();
                state = $state;
                controller = $controller;
            });
        });

        describe("when initialized", function () {
            it("should call httpGet with eula agreement endpoint", function () {
                controller = controller('EulaController', {$scope: scope});
                scope.$apply();

                expect(httpMock.get).toHaveBeenCalledWith('/eula/v1/agreement');
            });

            it("should set eulaContent", function () {
                controller = controller('EulaController', {$scope: scope});
                scope.$apply();

                expect(scope.eulaContent).toEqual('eulaContent');
            });
        });

    });
});