define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.factory('httpInterceptor', function ($q, $injector) {
		var interceptor = {};

		interceptor.responseError = function (rejection) {
			var newPromise;
			switch (rejection.status) {
				case 400:
					break;
				case 401:
					newPromise = $injector.invoke(['authenticationService', 'connectionErrorService', 'config', function (authenticationService, connectionErrorService, config) {
						var currentJwt = authenticationService.parseJwt(authenticationService.getJwtFromCookie(config.vamf_user.COOKIE));

						if (!currentJwt || !currentJwt.authenticated) {
							return authenticationService.authenticate();
						}

						return connectionErrorService.showAuthorizationErrorMsg();
					}]);

					break;
				case 403:
					break;
				case 404:
                    {
                        if(rejection.config && rejection.config.data && rejection.config.data.indexOf("SUBMITTED") >= 0)
                            break;
                    }
				default:
					if(rejection.status >= 100){
						newPromise = $injector.invoke(['authenticationService', 'connectionErrorService', function (authenticationService, connectionErrorService) {
							if (authenticationService.isAuthenticated() && navigator.onLine && !rejection.config.suppressErrorMsg) {
								return connectionErrorService.showServerErrorMsg(rejection);
							}
						}]);
					}
					break;
			}

			return newPromise || $q.reject(rejection);
		};

		return interceptor;

	});

});
