define(['angular', 'angularAnimate', 'angularBusy'], function (angular) {
	'use strict';


	angular.element("body").attr('cg-busy', 'delayed');

	angular.module('cgBusy').value('cgBusyDefaults', {
		templateUrl: 'angular-busy.html',
		delay: 0,
		minDuration: 500,   // is seems to start on init, leave it 0
		backdrop: false,
		message: ''
	});

	angular.module('delayManager', ['ngAnimate', 'cgBusy'])
		.factory('globalDelayTracker', function () {
			var globalDelayTracker = {};
			globalDelayTracker.tracker = {};
			globalDelayTracker.active = function() {
				return Object.keys(globalDelayTracker.tracker).length > 0;
			};

			globalDelayTracker.add = function(url) {
				globalDelayTracker.tracker[url] = globalDelayTracker.tracker[url] ? globalDelayTracker.tracker[url] + 1 : 1;
			};

			globalDelayTracker.remove = function(url) {
				if(globalDelayTracker.tracker[url] > 1) {
					globalDelayTracker.tracker[url] = globalDelayTracker.tracker[url] - 1;
				} else {
					delete globalDelayTracker.tracker[url];
				}
			};

			return globalDelayTracker;
		})

		.factory('busyHttpInterceptor', function ($q, globalDelayTracker) {

			return {
					// On request success
					request: function (config) {
						if (!config.background) {
							globalDelayTracker.add(config.url);
						}
						// Return the config or wrap it in a promise if blank.
						return $q.when(config);
					},
					// On request failure
					requestError: function (rejection) {
						return $q.reject(rejection);
					},
					// On response success
					response: function (response) {
						globalDelayTracker.remove(response.config.url);
						return $q.when(response);
					},
					// On response failture
					responseError: function (rejection) {
						globalDelayTracker.remove(rejection.config.url);
						return $q.reject(rejection);
					}
				};
			});
});