define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service("connectionTimeoutService", function ($http, $timeout, $state, $modal, unsavedWarningSharedService,config, authenticationService) {
		var service = {};

		var timeToExpire,
			timeUnitsText = "minutes",
			timeUnitText = "minute",
			displayTimeUnits = 60000, // one minute
			revalidateTime = 60000,
			warningThreshold = 3 * displayTimeUnits,
			conversionFactor = 1000,
			sessionEnded = false,
			timeoutPromise,
			modalInstance,
			modalInfo = {value: null, dismissed: true};

		var parseUserJwt = function(jwt){
			var userJwtPayload = {};
			if(jwt !== ''){
				var base64String = jwt.split('.')[1];
				var base64 = base64String.split('-').join('+').split('_').join('/');
				userJwtPayload = JSON.parse(window.atob(base64));
			}
			return userJwtPayload;
		};

		var getJwtFromCookie = function (cookieName) {
			var b = document.cookie.match('(^|;)\\s*' + cookieName + '\\s*=\\s*([^;]+)');

			return b ? b.pop() : '';
		};

		var timeoutDialogController = function () {
			var jwt = parseUserJwt(getJwtFromCookie(config.vamf_user.COOKIE));

            if(jwt.authenticated){
                timeToExpire = (jwt.exp * conversionFactor) - new Date().getTime();

                if (timeToExpire <= warningThreshold) {
                    showTimeoutWarning(timeToExpire);
                    revalidateTime = displayTimeUnits;
                }
                else {
                    dismissModal();
                    revalidateTime = timeToExpire - warningThreshold;
                }

                if (!sessionEnded) {
                    $timeout.cancel(timeoutPromise);
                    timeoutPromise = $timeout(function () {
                        timeoutDialogController();
                    }, revalidateTime, false);
                }
            }
            else {
                authenticationService.gotoLogoutWithRedirect();
			}
		};

		var dismissModal = function () {
			if (angular.isDefined(modalInstance) && !modalInfo.dismissed) {
				modalInfo.dismissed = true;
				modalInstance.dismiss();
			}
		};

		var openModal = function (template, controller, modalInfo) {
			dismissModal();

			modalInstance = $modal.open({
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		var showTimeoutWarning = function (timeToExpire) {
			var minutesToExpire = Math.round(parseInt(timeToExpire, 10) / displayTimeUnits);

			if (minutesToExpire <= 0) {
				sessionEnded = true;
                authenticationService.gotoLogoutWithRedirect();
				angular.element("div.container-fluid").remove();
			}
			else {
				modalInfo.value = minutesToExpire;
				modalInfo.unit = modalInfo.value !== 1 ? timeUnitsText : timeUnitText;
				openModal('modules/core/connection/timeout_warning_template.html', ModalInstanceCtrl, modalInfo);
			}
		};

		service.run = function () {
			timeoutDialogController();
		};

		service.showSessionEndedMsg = function () {
			sessionEnded = true;

			unsavedWarningSharedService.cleanAllForms();

			angular.element("div.container-fluid").remove();
			openModal('modules/core/connection/session_ended_template.html', ModalInstanceCtrl, modalInfo);
		};

		return service;
	});
});

function ModalInstanceCtrl($scope, $http, $modalInstance, $timeout, modalInfo, authenticationService, focusService) {
	modalInfo.dismissed = false;

	$timeout(function () {
		focusService.focusTopModal();
	}, 600);

	$scope.logout = function () {
		$modalInstance.dismiss();
		authenticationService.gotoLogoutWithRedirect();
	};
	$scope.proceed = function () {
		$http.get('/jwt').success(function(){
			$modalInstance.dismiss();
			modalInfo.dismissed = true;
			$modalInstance.result.finally(function(){
				focusService.focusMain();
			});
		});
	};
	$scope.launchpad = function () {
		$modalInstance.dismiss();
		authenticationService.logoutRedirectToLaunchpad();
	};
	$scope.login = function () {
		$modalInstance.dismiss();
		authenticationService.authorize();
	};

	$scope.modalInfo = modalInfo;
}


