define(['angular', 'angularMocks', 'app', 'MainController', 'angularUiRouter', 'Modernizr'], function(angular, mocks, app) {
    'use strict';

    describe('The Main controller', function () {

        var controller,
            scope,
            q,
            pageServiceMock,
            globalDelayTrackerMock;

        beforeEach( function () {
            module('angularTemplateApp');

            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
            module(function($provide){
                $provide.value('pageService', pageServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
            });

            globalDelayTrackerMock.active.and.returnValue(true);

            inject(function ($controller, $rootScope, $q, $templateCache) {
                scope = $rootScope.$new();
                spyOn(scope, '$on').and.callThrough();
                controller = $controller('MainController', {$scope: scope});
                q = $q;

                $templateCache.put('browserwarning_template.html', '<div />');
            });
        });

        describe("when global delay tracker is active", function(){
            beforeEach(function(){
                globalDelayTrackerMock.active.and.returnValue(true);
            });

            it("should create delay promise", function(){
                expect(scope.delayed.then).toEqual(jasmine.any(Function));
            });
        });

        describe("when global delay tracker is in-active", function(){

            var handler;

            beforeEach(function(){
                handler = jasmine.createSpy('resolve');
                scope.delayed.then(handler);
                globalDelayTrackerMock.active.and.returnValue(true);
                scope.$root.$digest();
                globalDelayTrackerMock.active.and.returnValue(false);
                scope.$root.$digest();
            });

            it("should resolve delay promise", function(){
                expect(handler).toHaveBeenCalledWith('finished');
            });
        });
    });
});