define(['Menu'], function() {
	'use strict';

	describe("The Menu directive", function (){
		var controller,
			scope,
			pageServiceMock,
			authenticationServiceMock,
			template,
			httpMock,
			snapRemoteMock,
			focusServiceMock;

		beforeEach( function () {
			module('angularTemplateApp');

			authenticationServiceMock = jasmine.createSpyObj('authenticationService',['logoutRedirectToLaunchpad','gotoLogoutWithRedirect', 'authenticate', 'isAuthenticated']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusPrimary', 'focusSecondary']);
			pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
			snapRemoteMock = jasmine.createSpyObj('snapRemote', ['getSnapper']);
			snapRemoteMock.getSnapper.and.callFake(function(){
				return { then: function() {} };
			});

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
				$provide.value('pageService', pageServiceMock);
				$provide.value('authenticationService', authenticationServiceMock);
				$provide.value('snapRemote', snapRemoteMock);
			});

			inject(function($compile, $rootScope, $httpBackend) {
				scope = $rootScope.$new();

				httpMock = $httpBackend;
				httpMock.whenGET('modules/container/components/menu/menu_template.html').respond('<div></div>');

				httpMock.when('GET', 'modules/container/components/menu/user-menu-items.json').respond([{
					"title": "Right Nav",
					"menuItems": [
						{
							"id":	"about",
							"text": "About",
							"modal": {
								"templateUrl": "modules/ui-components/modals/about/about_template.html",
								"controller": "AboutController"
							},
							"align": "top"
						},
						{
							"id":	"launchpad",
							"text": "Launchpad",
							"link": "launchpad",
							"align": "bottom"
						},
						{
							"id":	"logout",
							"text": "Logout",
							"link": "logout",
							"align": "bottom",
							"requiresAuth": true
						},
						{
							"id":	"login",
							"text": "Login",
							"link": "login",
							"align": "bottom",
							"requiresAuth": false
						}
					]
				}]);
				var element = angular.element("<div menu-include></div>");
				template = $compile(element)(scope);
				scope.$digest();
				controller = element.controller;

				httpMock.flush();
			});
		});

		describe("when logout is clicked", function (){
			beforeEach( function () {
				scope.openLink("logout");
			});

			it ("should call to redirect", function() {
				expect(authenticationServiceMock.gotoLogoutWithRedirect).toHaveBeenCalled();
			});
		});

		describe("when login is clicked", function (){
			beforeEach( function () {
				scope.openLink("login");
			});

			it ("should call to authenticate", function() {
				expect(authenticationServiceMock.authenticate).toHaveBeenCalled();
			});
		});

		describe("when launchpad is clicked", function (){
			beforeEach( function () {
				scope.openLink("launchpad");
			});

			it ("should call to redirect to launchpad", function() {
				expect(pageServiceMock.redirectToLaunchpad).toHaveBeenCalled();
			});
		});
	});
});