	define(['app', 'global', 'authentication_service'], function (app, global, authenticationService) {
	"use strict";
	app.directive('menuInclude', function () {
		return {
			replace: true,
			restrict: 'A',
			templateUrl: "modules/container/components/menu/menu_template.html",
			controller: function ($scope, $rootScope, $q, $http, $window, $timeout, $modal, $state, $filter, pageService, authenticationService, snapRemote, focusService) {

				var closeFocusHelper;

				snapRemote.getSnapper().then(function (snapper) {
					snapper.on('animated', function () {
						$timeout(function(){
							switch (snapper.state().state) {
								case "left":
									focusService.focusElement(angular.element('.snap-drawer-left .iOS-VO-overlap-accessible.panel-title'), true);
									break;
								case "right":
									focusService.focusElement(angular.element('.snap-drawer-right .iOS-VO-overlap-accessible.panel-title'), true);
									angular.element($window).trigger('resize');
									break;
							}
						});
					});
					snapper.on('open', function() {
						angular.element('#main-content-div').attr('aria-hidden', 'true');
						closeFocusHelper = "main";
					});
					snapper.on('close', function() {
						angular.element('#main-content-div').attr('aria-hidden', 'false');
						if(closeFocusHelper === "main") {
							focusService.focusMain();
						}
					});
					$scope.snapper = snapper;
				});

				var statesList = $state.get();
				$scope.navItems = $filter('orderBy')(statesList.filter(function(val){
					return val.appNavIndex > 0;
				}), "appNavIndex").map(function(val){
					val.data.id = val.data.appletName.replace(/\s/g, "");
					return val;
				});

				$http.get('modules/container/components/menu/user-menu-items.json')
					.then(function (menuItems) {
						$scope.userItems = menuItems.data.menuItems;

						$timeout(function () {
							angular.element($window).trigger('resize');
						});
					});

				angular.element($window).resize(function () {
					resizeList(angular.element('div[snap-drawer=right]'));
				});

				var isAuthenticated = authenticationService.isAuthenticated();
				$scope.authenticationFilter = function (menuItem) {
					if ($state.current.module === "preventNavigation" && $scope.navItems.indexOf(menuItem) !== -1) {
						return false;
					}
					if (menuItem.data && menuItem.data.requiresAuth === true|| menuItem.requiresAuth === true) {
						return isAuthenticated;
					}
					if (menuItem.data && menuItem.data.requiresAuth === false || menuItem.requiresAuth === false) {
						return !isAuthenticated;
					}

					return true;
				};

				function resizeList(listContainer) {
					var windowHeight;

					windowHeight = window.innerHeight;

					var totalListHeight = 0;

					totalListHeight += listContainer.find('.panel-header').outerHeight();
					listContainer.find('ul').each(function (index, element) {
						totalListHeight += angular.element(element).outerHeight(false);
					});

					var margin = windowHeight - totalListHeight;
					if (margin < 0) {
						margin = 0;
					}

					listContainer.find('ul').first().css('margin-bottom', margin + 'px');
				}

				$scope.closeMenu = function(){
					angular.element('#main-content-div').attr('aria-hidden', 'false');
					closeFocusHelper = "main";
				};

				$scope.openLink = function (link) {
					switch (link) {
						case "logout":
                            authenticationService.gotoLogoutWithRedirect();
							break;
						case "login":
							authenticationService.authenticate();
							break;
						case "launchpad":
							pageService.redirectToLaunchpad();
							break;
					}
				};

				$scope.openModal = function (item) {
					var modalInfo = item.modal,
						modalInstance = $modal.open({
							windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
							templateUrl: modalInfo.templateUrl,
							controller: modalInfo.controller
						});

					modalInstance.result.finally(function () {
						focusService.focusElement(angular.element('button[id=' + item.id + ']'));
					});
				};

				$scope.openSubApp = function (state, params) {
					$timeout(function () {
						$state.go(state.name, params);
						closeFocusHelper = "section";
					});
				};

				$scope.isSelected = function (item) {
					return $state.includes(item.name);
				};
			}
		};
	});
});
