define(['app', 'userSessionService', 'authentication_service'], function (app) {
	"use strict";
	app.controller('FooterController', function ($scope, userSessionService, authenticationService) {
		$scope.userName = null;
		$scope.advocateForName = null;
		$scope.facilityName = null;

		if (authenticationService.isAuthenticated()) {
			userSessionService.fetch().then(function (user) {
				loadUserDetails(user);
			});
		}

		function loadUserDetails(user) {
			if (user) {
				$scope.user = user;
				$scope.authenticated = ($scope.user || {}).authenticated;
			}
		}
	});
});