define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.controller('TwoPanelController', function ($scope, $rootScope, $state, focusService, pageService, globalDelayTracker) {
		$scope.responsive = pageService.responsive;
		$scope.exitPrimaryContent = pageService.exitPrimaryContent;
		$scope.globalDelayTracker = globalDelayTracker;

		var onViewChange = function() {
			if($state.current.data.panel === "secondary"){
				focusService.focusSecondary();
				pageService.responsive.primary = "0";
			} else if($state.current.data.panel === "primary") {
				focusService.focusPrimary();
				pageService.responsive.primary = "1";
			}
		}

		$scope.resolutionWidth = function(){
			return window.innerWidth < 768;
		};
		
		$scope.$on('$viewContentLoaded', onViewChange);
		$scope.$on('$stateChangeSuccess', onViewChange);

	});
});