/*jshint unused: vars */
require.config({
	paths: {

		/*                  Libraries                    */
		'angular'						: '../libs/angular/js/angular',
		'angularSanitize'				: '../libs/angular-sanitize/js/angular-sanitize',
		'angularTouch'					: '../libs/angular-touch/js/angular-touch',
		'angularAnimate'				: '../libs/angular-animate/js/angular-animate',
		'jQuery'						: '../libs/jquery/js/jquery',
		'text'							: '../libs/requirejs-text/text',
		'angularUiMask'					: '../libs/angular-ui-mask/js/mask',
		'angularUiRouter'				: '../libs/angular-ui-router/js/angular-ui-router',
		'angularUiBootstrap'			: '../libs/angular-bootstrap/js/ui-bootstrap-tpls-custom',
		'angularUiBootstrapOverwrites'	: '../libs/angular-bootstrap/js/ui-bootstrap-overwrites',
		'angularBusy'					: '../libs/angular-busy/js/angular-busy',
		'snap'							: '../libs/snap/js/snap',
		'angularSnap'					: '../libs/angular-snap/js/angular-snap',
        'moment'						: '../libs/moment/js/moment',
		'moment-timezone'				: '../libs/moment-timezone/js/moment-timezone-with-data',
		'lodash'						: '../libs/lodash/js/lodash',
		'FontFaceObserver'				: '../libs/fontfaceobserver/js/fontfaceobserver',

		/*                  Decorations                    */
		'ngMaskDecoration'				: 'decorations/ui-mask_decorator',
		'uiCollapseDecoration'			: 'decorations/ui-collapse_decorator',
		'ngClickDecoration'				: 'decorations/ng-click_decorator',

		/*                  Application                    */
		'appConfig'						: 'app-config',
		'app'							: 'app',
		'router'						: 'router',
		//templates is generated by grunt ngtemplate task
		'templates'						: 'templates',


		/*                  Container                    */
		'MainController'				: 'container/main/main_controller',

		'HeaderController'				: 'container/components/header/header_controller',
		'FooterController'				: 'container/components/footer/footer_controller',
		'TwoPanelController'			: 'container/components/content/two-column_controller',
		'List'							: 'container/components/content/list/list_directive',
		'Menu'							: 'container/components/menu/menu_directive',
		'SecondaryNavigationController' : 'container/components/content/secondary-navigation/secondary-navigation_controller',


		/*                  Applets                    */

		//Home
		'HomeModule'					: 'applets/home/home_module',
		'LandingController'				: 'applets/home/pages/landing/landing_controller',
		'AppSelectController'			: 'applets/home/pages/app-select/app-select_controller',
		'appSelectService'				: 'applets/home/pages/app-select/app-select_service',
		'TourController'				: 'applets/home/carousel-tour/carousel_controller',
		'carouselService'				: 'applets/home/carousel-tour/carousel_service',


		//Common
		'MediaRequestsController'		: 'applets/shared/pages/media-requests/media-requests_controller',
		'MediaRequestInfoController'	: 'applets/shared/pages/media-request-info/media-request-info_controller',
		'SubheaderController'			: 'applets/shared/pages/subheader/subheader_controller',
		'SubmitController'				: 'applets/shared/pages/submit/submit_controller',
		'FailedController'				: 'applets/shared/pages/submit-status/failed/failed_controller',
		'RetryController'				: 'applets/shared/pages/submit-status/retry/retry_controller',
		'SuccessController'				: 'applets/shared/pages/submit-status/success/success_controller',
		'ConsentController'				: 'applets/shared/pages/consent/consent_controller',
		'consentService'				: 'applets/shared/pages/consent/consent_service',
		'NavigationInstructionsService'	: 'applets/shared/services/navigation-instructions_service',
		'progressService'				: 'applets/shared/services/progress_service',
		'questionnaireService'			: 'applets/shared/services/questionnaire_service',
		'questionnaireResponseService'	: 'applets/shared/services/questionnaire-response_service',
		'submitEvaluationService'		: 'applets/shared/services/submit-evaluation_service',
		'mediaRequestTypes'		: 'applets/shared/services/media-request-types_value',

		//MyTelederm
		'MyTeledermModule'				: 'applets/mytelederm/mytelederm_module',
		'TeledermRequestsController'	: 'applets/mytelederm/pages/media-requests/telederm-requests_controller',
		'TeledermRequestsService'		: 'applets/mytelederm/pages/media-requests/telederm-requests_service',
		'TeledermRequestInfoController'	: 'applets/mytelederm/pages/media-request-info/telederm-request-info_controller',
		'TeledermEvalController'		: 'applets/mytelederm/pages/telederm-eval-controller/telederm-eval_controller',
		'TakeAnotherPictureController'	: 'applets/mytelederm/pages/take-another-picture/take-another-picture_controller',
		'ReviewPhotosController'		: 'applets/mytelederm/pages/review-photos/review-photos_controller',
		'TeledermSubmitController'		: 'applets/mytelederm/pages/submit/telederm-submit_controller',
		'TeledermRetryController'		: 'applets/mytelederm/pages/submit-status/telederm-retry_controller',
		'SkinStatusController'			: 'applets/mytelederm/pages/skin-status/skin-status_controller',
		'AdditionalCommentsController'	: 'applets/mytelederm/pages/additional-comments/additional-comments_controller',
		'PhotoInstructionsController'   : 'applets/mytelederm/pages/photo-instructions/photo-instructions_controller',
		'MedicationsController'			: 'applets/mytelederm/pages/medications/medications_controller',
		'MedicationsEntryController'	: 'applets/mytelederm/pages/medications/medications-entry_controller',
		'PhotoInputController'			: 'applets/mytelederm/pages/photo-input/photo-input_controller',
		'RequiredPhotoController'		: 'applets/mytelederm/pages/photo-input/required-photo/required-photo_controller',
		'OptionalPhotoController'		: 'applets/mytelederm/pages/photo-input/optional-photo/optional-photo_controller',
		'CloseUpPhotoController'		: 'applets/mytelederm/pages/photo-input/close-up-photo/close-up-photo_controller',
		'ResponseSummaryController'		: 'applets/mytelederm/pages/response-summary/response-summary_controller',

		'teledermSubmitStatusValue'		: 'applets/mytelederm/pages/submit-status/telederm-submit-status_value',
		'medicationTypesValue'			: 'applets/mytelederm/services/medication-types_value',

		'mediaRequestNavigationService'	: 'applets/mytelederm/services/media-request-navigation_service',
		'mediaRequestProgressService'	: 'applets/mytelederm/services/media-request-progress_service',
		'imageMediaRequestService'		: 'applets/mytelederm/services/image-media-request_service',
		'imageResponseService'			: 'applets/mytelederm/services/image-response_service',
		'imageRotationService'			: 'applets/mytelederm/services/image-rotation_service',
		'imageUploadService'			: 'applets/mytelederm/services/image-upload_service',
		'medicationsEntryService'		: 'applets/mytelederm/pages/medications/medications-entry_service',
		'teledermSubmitEvaluationService'	: 'applets/mytelederm/services/telederm-submit-evaluation_service',

		//MyVideo
		'MyVideoModule'					: 'applets/myvideo/myvideo_module',
		'VideoRequestsController'	: 'applets/myvideo/pages/media-requests/video-requests_controller',
		'VideoRequestInfoController'	: 'applets/myvideo/pages/media-request-info/video-request-info_controller',
		'VideoInstructionsController'	: 'applets/myvideo/pages/video-instructions/video-instructions_controller',
		'VideoUploadController'			: 'applets/myvideo/pages/video-upload/video-upload_controller',
		'VideoSubmitController'			: 'applets/myvideo/pages/submit/video-submit_controller',
		'VideoRetryController'			: 'applets/myvideo/pages/submit-status/video-retry_controller',

		'videoSubmitStatusValue'		: 'applets/myvideo/pages/submit-status/video-submit-status_value',

		'videoService'					: 'applets/myvideo/services/video_service',
		'videoRequestsService'	: 'applets/myvideo/pages/media-requests/video-requests_service',
		'videoUploadService'			: 'applets/myvideo/services/video-upload_service',
		'videoSubmitEvaluationService'	: 'applets/myvideo/services/video-submit-evaluation_service',

		/*                  Core Components                    */

		'BaseCRUDService'				: 'core/services/base-crud_service',
		'CollectionCRUDService'			: 'core/services/collection-crud_service',

		'httpInterceptor'				: 'core/connection/httpInterceptor',
		'connection_error_service'		: 'core/connection/connection_error_service',
		'connection_timeout_service'	: 'core/connection/connection_timeout_service',
		'delayManager'					: 'core/connection/delay_factory',

		'EulaController'				: 'core/eula/eula_controller',
		
		'fhirPatientService'			: 'core/resources/fhir-patient_service',
		'fhirResources'					: 'core/resources/fhir-resources_service',
		'localResourceDirectoryService'	: 'core/resources/local-resource-directory_service',
		'configValuesService'			: 'core/resources/config-values-service',
		'mhpuser_service'				: 'core/resources/mhpuser_service',
		'patient'						: 'core/resources/patient_service',
		'userSessionService'			: 'core/resources/user-session_service',
		'global'						: 'core/services/global',
		'formatter'						: 'core/services/formatter',
		'authentication_service'		: 'core/services/auth_service',
		'unsavedChanges'				: 'core/services/unsaved_changes',
		'focusManager'					: 'core/services/focus_directive',
		'local-storage_service'			: 'core/services/local-storage_service',
		'session-storage_service'		: 'core/services/session-storage_service',
		'afsFontFaceObserver'			: 'core/services/afs-font-face-observer',
		'fileValidationService'			: 'core/services/file-validation_service',

		/*                  ui-components                         */
		'AppLinks'						: 'ui-components/app-links/app-links_directive',

		'EntryForm'						: 'ui-components/form/entry-form/entry-form_directive',

		'FormControlWrapper'			: 'ui-components/form/controls/core/form-control-wrapper/form-control-wrapper_directive',
		'iOSKeyboard'					: 'ui-components/form/controls/core/iOS-keyboard/iOS-keyboard_directive',

		'InputRange'					: 'ui-components/form/controls/simple/input-range/input-range_directive',
		'InputSelect'					: 'ui-components/form/controls/simple/input-select/input-select_directive',
        'InputTypeAhead'				: 'ui-components/form/controls/simple/input-type-ahead/input-type-ahead_directive',
		'InputText'						: 'ui-components/form/controls/simple/input-text/input-text_directive',
		'InputFile'						: 'ui-components/form/controls/simple/input-file/input-file_directive',
		'InputNumber'					: 'ui-components/form/controls/simple/input-number/input-number_directive',
		'InputPhone'					: 'ui-components/form/controls/simple/input-phone/input-phone_directive',
		'InputPhoto'					: 'ui-components/form/controls/simple/input-photo/input-photo_directive',
		'InputVideo'					: 'ui-components/form/controls/simple/input-video/input-video_directive',
		'InputGroupCheckbox'			: 'ui-components/form/controls/simple/input-group-checkbox/input-group-checkbox_directive',
		'InputGroupRadio'				: 'ui-components/form/controls/simple/input-group-radio/input-group-radio_directive',
		'accessibleDatePickerServices'	: 'ui-components/form/controls/simple/accessibledatepicker/accessibledatepicker_directive',
		'accessibleTimePickerServices'	: 'ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_directive',

		'CalendarDatePicker'			: 'ui-components/form/controls/simple/calendar-date-picker/calendar-date-picker_directive',
    	'InputCalendarDatePicker'		: 'ui-components/form/controls/composite/input-calendar-date-picker/input-calendar-date-picker_directive',

		'TimeControls'					: 'ui-components/form/controls/composite/input-time-picker/time-controls_directive',
		'InputDateTime'					: 'ui-components/form/controls/composite/input-date-time/input-date-time_directive',
		'MultiPhone'					: 'ui-components/form/controls/composite/input-multi-phone/multi-phone_directive',
		'MultiTime'						: 'ui-components/form/controls/composite/input-multi-time-picker/multi-time_directive',

		'UserInputPattern'				: 'ui-components/form/validation/user-input-pattern/user-input-pattern_directive',
		'ValidationSummary'				: 'ui-components/form/validation/validation-summary/validation-summary',
		'ErrorHandling'					: 'ui-components/form/validation/validation-summary/error-handling_directive',
		'RequiredField'					: 'ui-components/form/validation/required-field-indicator/required-field-indicator_directive',

		'modalService'					: 'ui-components/modals/helper/modal_service',
		'HelpController'				: 'ui-components/modals/help/help_controller',
		'AboutController'				: 'ui-components/modals/about/about_controller',
		'ResourcesController'			: 'ui-components/modals/resources/resources_controller',
		'ConfirmSaveController'			: 'ui-components/modals/confirm-save/confirm-save_controller',
		'ConfirmDialController'			: 'ui-components/modals/confirm-dial/confirm-dial_controller',
		'ConfirmNavigationController'	: 'ui-components/modals/confirm-navigation/confirm-navigation_controller',
		'NavigationInstructionsController'	: 'ui-components/modals/navigation-instructions/navigation-instructions_controller',
		'VideoRequirementsController'	: 'ui-components/modals/video-requirements/video-requirements_controller',
		'ViewVideoController'			: 'ui-components/modals/view-video/view-video_controller',
		'PhotoTipsController'			: 'ui-components/modals/photo-tips/photo-tips_controller',
		'ConsentDeclinedController'		: 'ui-components/modals/consent-declined/consent-declined_controller',
		'ReviewPhotoTipsController'		: 'ui-components/modals/review-photos-tips/review-photos-tips_controller',
		'ConfirmMediaUpdateController'	: 'ui-components/modals/confirm-media-update/confirm-media-update_controller',

		'NavBar'						: 'ui-components/nav-bar/nav-bar_directive',
		'ProgressBar'					: 'ui-components/progress-bar/progress-bar_directive',
		'ScrollIndicator'				: 'ui-components/scroll-indicator/scroll-indicator_directive',
		'FilterWrapper'					: 'ui-components/filter/filter-wrapper_directive',
		'StatusFilter'					: 'ui-components/filter/status-filter/status-filter_directive',

		'AriaHidden'					: 'ui-components/accessibility/aria-hidden/aria-hidden_directive',
		'SrAlert'						: 'ui-components/accessibility/sr-alert/sr-alert_directive',

		'aDirective'					: 'ui-components/html-extensions/a_directive',
		'iDirective'					: 'ui-components/html-extensions/i_directive',

		'limitLength'					: 'ui-components/limit-length/limit-length_filter',

		'DataTableDirective'			: 'ui-components/table/table_directive',

		'BackButton'					: 'ui-components/back-button/back-button_directive',

		'AccessibleAccordion'			: 'ui-components/accordion/accessibleaccordion_directive',

		'accessibleCarousel'			: 'ui-components/carousel/accessible-carousel_directive',

		'AccessibleCarouselController'	: 'ui-components/carousel/accessible-carousel_controller',

		'disableNgAnimate'				: 'ui-components/disable-ng-animate/disable-ng-animate_directive',

		'ngFileSelect'					: 'ui-components/ng-file-select/ng-file-select_directive'
	},
	shim: {
		'angular'					: {deps: ['jQuery'], 'exports': 'angular'},
		'jQuery'					: {'exports': '$'},
		'lodash'					: {'exports': '_'},
        'moment'					: {'exports' : 'moment'},
		'moment-timezone'			: ['moment'],
		'angularSanitize'			: ['angular'],
		'angularUiMask'				: ['angular'],
		'angularUiRouter'			: ['angular'],
		'angularUiBootstrap'		: ['angular'],
		'angularUiBootstrapOverwrites'		: ['angularUiBootstrap'],
		'angularTouch'				: ['angular'],
		'angularBusy'				: ['angular'],
		'angularSnap'				: ['angular', 'snap'],
		'angularAnimate'			: ['angular'],
		'templates'					: ['app'],
		'FontFaceObserver'			: {'exports': 'FontFaceObserver'}
	},
	priority: ['angular']
});

require(
	[
		'app',
		'angular',
		'angularTouch',
		'angularUiMask',
		'angularUiRouter',
		'angularSanitize',
		'angularAnimate',
		'angularBusy',
		'AriaHidden',
		'SrAlert',
		'router',
		'Menu',
		'EntryForm',
		'InputRange',
		'InputSelect',
        'InputTypeAhead',
		'InputText',
		'InputFile',
		'InputNumber',
		'InputPhone',
		'InputPhoto',
		'InputVideo',
		'InputGroupCheckbox',
		'InputGroupRadio',
		'ValidationSummary',
		'UserInputPattern',
		'angularUiBootstrap',
		'angularUiBootstrapOverwrites',
		'global',
		'httpInterceptor',
		'unsavedChanges',
		'focusManager',
		'delayManager',
		'templates',
		'appConfig',
		'formatter',
		'InputDateTime',
		'ErrorHandling',
		'FormControlWrapper',
		'iOSKeyboard',
		'List',
		'FilterWrapper',
		'StatusFilter',
		'uiCollapseDecoration',
		'MultiTime',
		'MultiPhone',
		'aDirective',
		'RequiredField',
		'DataTableDirective',
		'BackButton',
		'AccessibleAccordion',
		'accessibleCarousel',
		'AccessibleCarouselController',
		'disableNgAnimate',
		'ngFileSelect',
		'iDirective',
		'moment-timezone',
		'ResourcesController',
		'NavigationInstructionsController',
		'VideoRequirementsController',
		'ViewVideoController',
		'PhotoTipsController',
		'ConsentDeclinedController',
		'NavBar',
		'ProgressBar',
		'ScrollIndicator',
		'BaseCRUDService',
		'CollectionCRUDService',
		'ngClickDecoration',
		'ngMaskDecoration',
		'lodash',
		'CalendarDatePicker',
    	'InputCalendarDatePicker',
		'afsFontFaceObserver',
		'MediaRequestsController',
		'MediaRequestInfoController',
		'SubheaderController',
		'SubmitController',
		'NavigationInstructionsService',
		'ReviewPhotoTipsController',
		'FailedController',
		'RetryController',
		'SuccessController',
		'ConsentController',
		'ConfirmDialController',
		'ConfirmNavigationController',
		'consentService',
		'fileValidationService',
		'ConfirmMediaUpdateController'
	], function (app, angular) {
		'use strict';

		angular.element().ready(function () {
			angular.element('html').removeClass('hidden');

			angular.bootstrap(document, [app.name]);
		});
	});
