define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('submitEvaluationService', function ($state) {
        return {
            reset: function () {
                this.retries = 3;
            },
            resubmit: function () {
                this.retries--;

                this.submit();
            },
            submit: function () {
                var that = this;

                this.submitFunction().then(function () {
                    $state.go(that.successRoute);
                }, function () {
                    if (that.retries > 0) {
                        $state.go(that.retryRoute, {}, {reload: true});
                    } else {
                        $state.go(that.failedRoute);
                    }
                });
            }
        };
    });
});