define(['submitEvaluationService'], function() {
    'use strict';

    describe("Submit Evaluation Service", function () {
        var service,
            stateMock,
            successCallback,
            errorCallback;

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);

            module(function ($provide) {
                $provide.value('$state', stateMock);
            });

            inject(function (submitEvaluationService) {
                service = submitEvaluationService;

                service.successRoute = 'success-route';
                service.retryRoute = 'retry-route';
                service.failedRoute = 'failed-route';

                service.submitFunction = function () {};

                spyOn(service, 'submitFunction').and.returnValue({
                    then: function (success, error) {
                        successCallback = success;
                        errorCallback = error;
                    }
                });
            });
        });

        describe("reset function", function () {
            it("should reset the number of retries to 3", function () {
                service.retries = 1;

                service.reset();

                expect(service.retries).toEqual(3);
            });
        });

        describe("resubmit function", function () {
            beforeEach(function () {
                spyOn(service, 'submit');

                service.retries = 3;

                service.resubmit();
            });

            it("should reduce the number of retries by 1", function () {
                expect(service.retries).toEqual(2);
            });

            it("should call submit", function () {
                expect(service.submit).toHaveBeenCalled();
            });
        });

        describe("submit function", function () {
            beforeEach(function () {
                service.submit();
            });

            it("should call the submitFunction", function () {
                expect(service.submitFunction).toHaveBeenCalled();
            });

            it("should redirect the user to the success route when the submit is successful", function () {
                successCallback();

                expect(stateMock.go).toHaveBeenCalledWith('success-route');
            });

            describe("submit error", function () {
                it("should redirect the user to the retry screen if the number of retries is greater than 0", function () {
                    service.retries = 2;

                    errorCallback();

                    expect(stateMock.go).toHaveBeenCalledWith('retry-route', {}, {reload: true});
                });

                it("should redirect the user to the failed screen if the number of retries is 0", function () {
                    service.retries = 0;

                    errorCallback();

                    expect(stateMock.go).toHaveBeenCalledWith('failed-route');
                });
            });
        });
    });
});