define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('questionnaireService', function ($http, $q, fhirResources) {

		var directory = {},
			isReady;

		directory.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			$http.get("questionnaire_config.json").success(function (responses) {
				var resources = responses;
				resources.conf.forEach(function (conf) {
					directory[conf.title] = conf.id;
				});
				isReady.resolve(directory);
			}).error(function (error) {
				isReady.reject(error);
				isReady = null;
			});

			isReady = $q.defer();

			return isReady.promise;

		};

		directory.getQuestionnaire = function(name){
			var deferred = $q.defer();
			this.fetch().then(function(questionConfig) {
				var questionnaireData = {resourceName: "Questionnaire", params: {identifier: ""}};
				questionnaireData.params.identifier = questionConfig[name];
				fhirResources.resolveFhirResourceByParams(questionnaireData.resourceName, questionnaireData.params)
					.then(function (questionnaire) {
						deferred.resolve(questionnaire[0]);
					});
			});
			return deferred.promise;
		};

		return directory;
	});
});
