define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('progressService', function () {
        return {
            progressServiceInstance: {
                getNumCompleted: function () {
                    return 0;
                },
                getTotalSteps: function () {
                    return 1;
                }
            },
            setProgressServiceInstance: function (progressServiceInstance) {
                this.progressServiceInstance = progressServiceInstance;
            },
            getProgress: function () {
                var service = this.progressServiceInstance;

                return Math.round((service.getNumCompleted() / service.getTotalSteps()) * 100);
            }
        };
    });
});