define(['progressService'], function () {
    'use strict';

    describe('Progress Service', function () {
        var service;

        beforeEach(function () {
            module('angularTemplateApp');

            inject(function (progressService) {
                service = progressService;
            });
        });

        it('should calculate 0% progress by default', function () {
            expect(service.getProgress()).toEqual(0);
        });

        it('should calculate progress based on the given object', function () {
            service.setProgressServiceInstance({
                getNumCompleted: function () {
                    return 5;
                },
                getTotalSteps: function () {
                    return 10;
                }
            });

            expect(service.getProgress()).toEqual(50);
        });
    });
});