define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('NavigationInstructionsService', function ($modal) {
        return {
            openModal: function () {
                $modal.open({
                    windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
                    templateUrl: 'modules/ui-components/modals/navigation-instructions/navigation-instructions_template.html',
                    controller: 'NavigationInstructionsController',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        modalInfo: function () {
                            return {value: null, dismissed: true, resendHash: []};
                        }
                    }
                });
            }
        };
    });
});