define(['NavigationInstructionsService'], function () {
	'use strict';

	describe('Navigation Instructions Service', function () {
		var service, modalMock;

		beforeEach(function () {
			module('angularTemplateApp');

			modalMock = jasmine.createSpyObj('$modal', ['open']);
			module(function ($provide) {
				$provide.value('$modal', modalMock);
			});

			inject(function (NavigationInstructionsService) {
				service = NavigationInstructionsService;
			});
		});

		it('should have open modal function', function () {
			expect(service.openModal).toBeDefined();
		});

		it('should open modal with params if function is called', function () {
			var modalParams = {
				windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'modules/ui-components/modals/navigation-instructions/navigation-instructions_template.html',
				controller: 'NavigationInstructionsController',
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return {value: null, dismissed: true, resendHash: []};
					}
				}
			};

			modalMock.open.and.callFake(function() {
				expect(arguments[0].windowTemplateUrl).toEqual(modalParams.windowTemplateUrl);
				expect(arguments[0].templateUrl).toEqual(modalParams.templateUrl);
				expect(arguments[0].controller).toEqual(modalParams.controller);
				expect(arguments[0].backdrop).toEqual(modalParams.backdrop);
				expect(arguments[0].keyboard).toEqual(modalParams.keyboard);
			});

			service.openModal();
		});

	});
});