define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.controller('SubmitController', function ($scope, $rootScope, $state, $http, fhirPatient, formatter) {
        $scope.contactType = 'email';
        $scope.contactInfo = {
            email: '',
            phone: ''
        };
        $scope.fhirPatient = {};

        $scope.resetContactInfo = function () {
            var telecom = $scope.fhirPatient.telecom || [],
                email = '',
                phone = '';

            telecom.forEach(function (telecomEntry) {
                if (telecomEntry.system === 'email' && telecomEntry.use === 'home') {
                    email = telecomEntry.value;
                    if (telecomEntry.rank == 1) {
                        $scope.contactType = telecomEntry.system;
                    }
                }

                if (telecomEntry.system === 'phone' && telecomEntry.use === 'mobile') {
                    phone = telecomEntry.value;
                    if (telecomEntry.rank == 1) {
                        $scope.contactType = telecomEntry.system;
                    }
                }
            });

            $scope.contactInfo = {
                email: email,
                phone: phone
            };
        };

        $scope.validateEmail = function () {
            var validEmail = true;
            
            if ($scope.contactInfo.email && !$scope.contactInfo.email.match(/^[A-Za-z0-9._%+-]+@[A-Za-z0-9\.\-]+\.[A-Za-z]{2,4}$/)) {
                validEmail = false;
            }

            $scope.contactInfoForm.$setValidity('Valid-Email-Address', validEmail);
        };

        $scope.validatePhoneGiven = function () {
            var phoneProvided = true;

            if ($scope.contactType === 'phone' && !$scope.contactInfo.phone) {
                phoneProvided = false;
            }

            $scope.contactInfoForm.$setValidity('Phone-Number-Given', phoneProvided);
        };

        $scope.validateValidPhone = function () {
            var validPhone = true;
            
            if ($scope.contactInfo.phone && !($scope.contactInfo.phone.match(/^[0-9]{10}$/) ||
                                              $scope.contactInfo.phone.match(/^([0-9]{3}-){2}[0-9]{4}$/) ||
                                              $scope.contactInfo.phone.match(/^\([0-9]{3}\) [0-9]{3}-[0-9]{4}$/))) {
                validPhone = false;
            }

            $scope.contactInfoForm.$setValidity('Valid-Phone-Number', validPhone);
        };

        $scope.validate = function () {
            $scope.validateEmail();
            $scope.validatePhoneGiven();
            $scope.validateValidPhone();
        };

        $scope.emailEntryCheck = function (entry) {
            return entry.system === 'email' && entry.use === 'home';
        };

        $scope.phoneEntryCheck = function (entry) {
            return entry.system === 'phone' && entry.use === 'mobile';
        };

        $scope.updateEmailForFhirPatient = function () {
            if ($scope.contactInfo.email) {
                var telecom = $scope.fhirPatient.telecom || [];

                telecom = _.filter(telecom, function (telecomEntry) {
                    return !($scope.emailEntryCheck(telecomEntry));
                });

                telecom.push({
                    system: 'email',
                    value: $scope.contactInfo.email,
                    use: 'home'
                });

                $scope.fhirPatient.telecom = telecom;
            }
        };

        $scope.updatePhoneForFhirPatient = function () {
            var telecom = $scope.fhirPatient.telecom || [];

            telecom = _.filter(telecom, function (telecomEntry) {
                return !($scope.phoneEntryCheck(telecomEntry));
            });

            if ($scope.contactInfo.phone) {
                telecom.push({
                    system: 'phone',
                    value: $scope.contactInfo.phone,
                    use: 'mobile'
                });
            }

            $scope.fhirPatient.telecom = telecom;
        };

        $scope.updateContactPreferenceRank = function () {
            var telecom = $scope.fhirPatient.telecom || [];

            telecom.forEach(function (telecomEntry) {
                telecomEntry.rank = $scope[$scope.contactType + 'EntryCheck'](telecomEntry) ? 1 : 2;
            });

            $scope.fhirPatient.telecom = telecom;
        };

        $scope.updateContactForFhirPatient = function () {
            $scope.updateEmailForFhirPatient();
            $scope.updatePhoneForFhirPatient();
            $scope.updateContactPreferenceRank();
        };

        $scope.submit = function () {
            $scope.validate();
            $scope.contactInfoForm.validationSummary.validate().then(function () {
                $scope.updateContactForFhirPatient();
                fhirPatient.update($scope.fhirPatient).then(function () {
                    $scope.submitCallback();
                });
            });
        };

        $scope.errorHandling = {
            'Valid-Email-Address' : {
                message : 'Invalid email address',
                priority : 1
            },
            'Phone-Number-Given' : {
                message : 'You have chosen to be notified by phone but no phone number was provided.',
                priority : 1
            },
			'Valid-Phone-Number' : {
				message : 'You have entered an invalid phone number (formats accepted are: xxxxxxxxxx, xxx-xxx-xxxx, or (xxx) xxx-xxxx)',
				priority : 1
            }
		};

        $scope.previous = function () {
            $scope.previousCallback();
        };

		$scope.swipeLeft = function(){
            if ($scope.showProgressBar) {
                $rootScope.$broadcast('swipeLeft');
            }
            else {
                $scope.previous();
            }
        };

        fhirPatient.fetch().then(function (response) {
            $scope.fhirPatient = response;
            $scope.resetContactInfo();
        });
    });
});