define(['RetryController'], function () {
    'use strict';

    describe('Retry Controller', function () {
        var controller,
            scope,
            focusServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

            module(function ($provide) {
                $provide.value('$stateParams', {
                    topText: 'Top Text',
                    submitType: 'appointment'
                });
                $provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', {});
            });

            inject(function ($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;

                scope.submitEvaluationService = {
                    retries: 3,
                    resubmit: function () {}
                };

                spyOn(scope.submitEvaluationService, 'resubmit');
            });
        });

        describe("initial state", function () {
            beforeEach(function () {
                controller = controller('RetryController', {$scope: scope});
            });

            it("should set the subtitle and inject the current number of retries", function () {
                expect(scope.subtitle).toEqual('Submit failed. Attempts remaining: 3');
            });

            it("should correctly set the statusTemplate", function () {
                expect(scope.statusTemplate).toEqual('modules/applets/shared/pages/submit-status/retry/retry_template.html');
            });

            it("should extend the stateParams", function () {
                expect(scope.topText).toEqual('Top Text');
                expect(scope.submitType).toEqual('appointment');
            });
        });

        describe("submit function", function () {
            it("should resubmit the evaluation", function () {
                controller = controller('RetryController', {$scope: scope});

                scope.submit();

                expect(scope.submitEvaluationService.resubmit).toHaveBeenCalled();
            });
        });

        it("should extend the SubheaderController", function () {
            controller = controller('RetryController', {$scope: scope});

            expect(focusServiceMock.focusElement).toHaveBeenCalledWith('.primary-header h2');
        });
    });
});