define(['FailedController'], function () {
    'use strict';

    describe('Failed Controller', function () {
        var controller,
            scope,
            stateMock,
            focusServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('$stateParams', {
                    providerType: 'provider',
                    topText: 'Top Text',
                    submitType: 'appointment'
                });
                $provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', {});
            });

            inject(function ($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("initial state", function () {
            beforeEach(function () {
                controller = controller('FailedController', {$scope: scope});
            });

            it("should correctly set the statusTemplate", function () {
                expect(scope.statusTemplate).toEqual('modules/applets/shared/pages/submit-status/failed/failed_template.html');
            });

            it("should extend the stateParams", function () {
                expect(scope.providerType).toEqual('provider');
                expect(scope.topText).toEqual('Top Text');
                expect(scope.submitType).toEqual('appointment');
            });
        });

        describe("goHome function", function () {
            it("should redirect the user to the app-select page", function () {
                controller = controller('FailedController', {$scope: scope});

                scope.goHome();

                expect(stateMock.go).toHaveBeenCalledWith('main.app-select');
            });
        });

        it("should extend the SubheaderController", function () {
            controller = controller('FailedController', {$scope: scope});

            expect(focusServiceMock.focusElement).toHaveBeenCalledWith('.primary-header h2');
        });
    });
});