define(['SubheaderController'], function () {
    'use strict';

    describe('Subheader Controller', function () {
        var controller,
            scope,
            stateParams = {},
            elementMock,
            focusServiceMock,
            globalDelayTrackerMock;

        beforeEach(function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTrackerMock', ['active']);

            elementMock = {
                addClass: function () {},
                data: function () {}
            };

            spyOn(elementMock, 'addClass');

            spyOn(angular, 'element').and.returnValue(elementMock);

            module(function ($provide) {
                $provide.value('$stateParams', stateParams);
                $provide.value('focusService', focusServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
            });

            inject(function ($rootScope, $controller) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        it('should add the inner-scroll class to the primary content', function () {
            controller = controller('SubheaderController', {$scope: scope});

            expect(angular.element).toHaveBeenCalledWith('.primary-content');
            expect(elementMock.addClass).toHaveBeenCalledWith('inner-scroll');
        });

        describe('subtitle attribute', function () {
            it('should be set to the preexisting subtitle value', function () {
                scope.subtitle = 'Preexisting subtitle';

                controller = controller('SubheaderController', {$scope: scope});

                expect(scope.subtitle).toEqual('Preexisting subtitle');
            });

            it('should be set to the preexisting value instead of the value from the $stateParams if set', function () {
                scope.subtitle = 'Preexisting subtitle';
                stateParams.subtitle = 'subtitle from $stateParams';

                controller = controller('SubheaderController', {$scope: scope});

                expect(scope.subtitle).toEqual('Preexisting subtitle');
            });

            it('should be set to the value passed in the $stateParams, if there is no preexisting value', function () {
                scope.subtitle = null;
                stateParams.subtitle = 'subtitle from $stateParams';

                controller = controller('SubheaderController', {$scope: scope});

                expect(scope.subtitle).toEqual('subtitle from $stateParams');
            });

            it('should be set to an empty string if there is no preexisting value, and no value from $stateParams', function () {
                scope.subtitle = null;
                stateParams.subtitle = null;

                controller = controller('SubheaderController', {$scope: scope});

                expect(scope.subtitle).toEqual('');
            });
        });

        it('should set the globalDelayTracker', function () {
            controller = controller('SubheaderController', {$scope: scope});

            expect(scope.globalDelayTracker).toEqual(globalDelayTrackerMock);
        });

        it('should call focusElement on the subheader', function () {
            controller = controller('SubheaderController', {$scope: scope});

            expect(focusServiceMock.focusElement).toHaveBeenCalledWith('.primary-header h2');
        });
    });
});