define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.controller('MediaRequestsController', function ($scope, $state, $modal, $q, formatter, globalDelayTracker,focusService) {
		$scope.globalDelayTracker = globalDelayTracker;
		focusService.focusMain();

        $scope.statusMenuItems = [
            "Pending",
            "Submitted",
            "Completed",
            "Expired",
			"All"
		];
        
        $scope.filter = $scope.filter || {};
        $scope.filter.service = $scope.service;

        $scope.filter.defaults = $scope.filter.defaults || {};
        $scope.filter.defaults.endDate = formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(new Date(), {days: 270}));
        $scope.filter.defaults.startDate = formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(new Date(), {days: -90}));
        $scope.filter.defaults.status = 'Pending';
		$scope.filter.defaults.displayStatus = 'Pending';
		$scope.filter.defaults.requestType = $scope.requestType;

		$scope.filter.model = angular.copy($scope.filter.defaults);
		$scope.filter.callbacks = function(){
			$scope.filter.model.displayStatus = $scope.filter.model.status;
			$scope.table.columns.forEach(function(item) {
				if(item.keys === 'startDate'){
					item.isSortKey = true;
					item.reverse = true;
				} else{
					item.isSortKey = false;
					item.reverse = false;
				}
			});
		}

		$scope.service.fetch($scope.service.dataPointers ? ($scope.service.dataPointers.filters || $scope.filter.defaults) : $scope.filter.defaults);


		$scope.selectEval = function(mediaRequest) {
            $scope.selectEvalCallback(mediaRequest).then(function () {;
                $state.go($scope.routeBase + '-info');
            });
		};
		
		$scope.sortMediaRequests = function(header) {
			$scope.table.columns.forEach(function (item) {
				item.isSortKey = false;
			});
			header.isSortKey = true;
			header.reverse = !header.reverse;
			$scope.service.dataPointers.list = $scope.service.sort($scope.service.dataPointers.list, header.keys, header.reverse);
		}

	});
});
