define(['MediaRequestsController'], function() {
	'use strict';

	describe("The Media Requests Controller", function () {
		var controller,
			scope,
			stateMock,
			globalDelayTrackerMock,
			TeledermRequestsServiceMock,
			formatterMock,
			formattedStartDate,
			formattedEndDate,
			header = { keys: 'startDate', reverse:true, isSortKey:false},
			modalMock,
			focusServiceMock;

		beforeEach(function () {
			module('angularTemplateApp');

			var startDate = new Date();
			startDate.setDate(startDate.getDate() - 90);
			var endDate = new Date();
			endDate.setDate(endDate.getDate() + 270);

			formattedStartDate = ("0" + (startDate.getMonth() + 1)).slice(-2) + "/" + ("0" + startDate.getDate()).slice(-2) + "/" + ( startDate.getFullYear());
			formattedEndDate = ("0" + (endDate.getMonth() + 1)).slice(-2) + "/" + ("0" + endDate.getDate()).slice(-2) + "/" +  endDate.getFullYear();

			stateMock = jasmine.createSpyObj('$state', ['go']);
			modalMock = jasmine.createSpyObj('$modal', ['open']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
			globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
			formatterMock = jasmine.createSpyObj('formatter', ['getFormattedBackendDate', 'getFormattedFrontendDate']);
			formatterMock.getFormattedBackendDate.and.returnValue(formattedStartDate);
			formatterMock.getFormattedFrontendDate.and.returnValue(formattedEndDate);
			TeledermRequestsServiceMock = jasmine.createSpyObj('TeledermRequestsService', ['fetch','sort']);

			TeledermRequestsServiceMock.fetch.and.callFake(function () {
				scope.service.dataPointers =
					{
						list: [],
						filters: [],
						unfilteredItemCount: 0
					};
				scope.service.config =
					{
						collection: {
						objectType: "MediaRequests",
						name: "requests",
						sortComparator: [{key: "startDate", reverse: true}]
						}
					};
				return '';
			});

			TeledermRequestsServiceMock.sort.and.callFake(function () {
				return "";
			});

			module(function ($provide) {
				$provide.value('$state', stateMock);
				$provide.value('globalDelayTracker', globalDelayTrackerMock);
				$provide.value('TeledermRequestsService', TeledermRequestsServiceMock);
				$provide.value('$modal', modalMock);
				$provide.value('focusService', focusServiceMock);

			});

			inject(function($controller, $rootScope,$modal, formatter) {
				scope = $rootScope.$new();
				scope.service = TeledermRequestsServiceMock;
				scope.service.fetch();
				scope.routeBase = 'main.mytelederm.authorization';
				scope.table = {
					columns : [
						{ keys: "startDate", reverse: true, isSortKey: true},
						{ keys: "endDate", reverse: false, isSortKey: false},
						{ keys: "requestReason", reverse: false, isSortKey: false},
						{ keys: "status", reverse: false, isSortKey: false}
					]
				};

				controller = $controller;

			});
		});

		describe("page focus", function () {
			it("should focus the header", function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.$apply();
				expect(focusServiceMock.focusMain).toHaveBeenCalled();
			});
		});

		describe("setting the filter values", function () {
			it("should have filter defaults on init", function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.$apply();
				expect(scope.statusMenuItems).toBeDefined();
				expect(scope.statusMenuItems).toEqual([
					"Pending",
					"Submitted",
					"Completed",
					"Expired",
					"All"
				]);
				expect(scope.filter).toBeDefined();
				expect(scope.filter.service).toBeDefined();
				expect(scope.filter.defaults.startDate).toBeDefined();
				expect(scope.filter.defaults.endDate).toBeDefined();

				expect(scope.filter.defaults.startDate).toEqual(formattedStartDate);
				expect(scope.filter.defaults.endDate).toEqual(formattedEndDate);

				expect(scope.filter.defaults.status).toEqual("Pending");
				expect(scope.filter.model).toBeDefined();
				expect(scope.filter.defaults.displayStatus).toEqual("Pending");
			});
		});

		describe('the initial service fetch', function () {
			it('should fetch the list with the default filters if dataPointers doesn\'t exist on the service', function () {
				scope.service.dataPointers = null;

				controller = controller('MediaRequestsController', {$scope: scope});

				expect(scope.service.fetch).toHaveBeenCalledWith(scope.filter.defaults);
			});

			it('should fetch the list with the default filters if the dataPointers object doesn\'t have filters', function () {
				scope.service.dataPointers = {};

				controller = controller('MediaRequestsController', {$scope: scope});

				expect(scope.service.fetch).toHaveBeenCalledWith(scope.filter.defaults);
			});

			it('should fetch the list with the filters set on the dataPointers', function () {
				var date = new Date(),
					filters = {
						startDate: ("0" + (date.getMonth() + 1)).slice(-2) + "/" + ("0" + date.getDate()).slice(-2) + "/" + ( date.getFullYear() - 2),
						endDate: ("0" + (date.getMonth() + 1)).slice(-2) + "/" + ("0" + date.getDate()).slice(-2) + "/" +  ( date.getFullYear() + 1) ,
						status: 'Submitted',
						displayStatus: 'Submitted'
					};

				scope.service.dataPointers = {
					filters: filters
				};

				controller = controller('MediaRequestsController', {$scope: scope});

				expect(scope.service.fetch).toHaveBeenCalledWith(filters);
			});
		});

		describe('the sort function', function () {
			it ('should sort the table list', function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.sortMediaRequests(header);
				expect(header.isSortKey).toEqual(true);
				expect(header.reverse).toEqual(false);
				expect(scope.filter.service.sort).toHaveBeenCalled();
			});
		});

		describe('the selectEval function', function () {
			it ('should go to the details page', function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.selectEvalCallback = function () {
					return {
						then: function (callback) {
							callback();
						}
					};
				};
				scope.selectEval();
				expect(stateMock.go).toHaveBeenCalledWith('main.mytelederm.authorization-info');
			});
		});

		describe('the data fetch function', function () {
			it ('should call the telederm authorization service fetch', function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.service.fetch(scope.filter.defaults);
				expect(TeledermRequestsServiceMock.fetch).toHaveBeenCalledWith(scope.filter.defaults);
			});
		});

		describe('the filter callback function', function () {
			it ('should call filter callback function', function () {
				controller = controller('MediaRequestsController', {$scope: scope});
				scope.filter.callbacks();
				expect(scope.table.columns[0].isSortKey).toEqual(true);
				expect(scope.table.columns[0].reverse).toEqual(true);
				expect(scope.table.columns[1].isSortKey).toEqual(false);
				expect(scope.table.columns[1].reverse).toEqual(false);
				expect(scope.table.columns[2].isSortKey).toEqual(false);
				expect(scope.table.columns[2].reverse).toEqual(false);
				expect(scope.table.columns[3].isSortKey).toEqual(false);
				expect(scope.table.columns[3].reverse).toEqual(false);
			});
		});

	});
});
