define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.controller('MediaRequestInfoController', function ($scope, $state, formatter) {
        var currentDate = new Date();

        $scope.todayDate = formatter.getFormattedFrontendDate(currentDate);
        $scope.isValidDateRange = new Date($scope.todayDate) >= new Date($scope.mediaRequest.startDate) && new Date($scope.todayDate) <= new Date($scope.mediaRequest.endDate);

        var requestedMedia = [];
        $scope.mediaRequest.mediaTypes.forEach(function (mediaType) {
            requestedMedia.push(mediaType.description);
        });

        $scope.requestedMedia = requestedMedia.join(', ');

        $scope.continue = function () {
			$scope.continueCallback();
        };

        $scope.review = function (event) {
           $scope.reviewCallback(event);
        };

        $scope.back = function () {
            $state.go($scope.routeBase);
        };
    });
});