define(['MediaRequestInfoController'], function() {
    'use strict';

    describe("The Media Request Info Controller", function () {
        var controller,
            scope,
            stateMock,
            eventMock,
            mediaRequest = {
                mediaTypes: [],
                providerContacts: []
            };

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            eventMock = {
                currentTarget: {}
            };

            module(function ($provide) {
                $provide.value('$state', stateMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;
            });
        });

        describe("setting the requestedMedia", function (){
            it ("should return an empty string if there are no mediaTypes", function() {
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.$apply();
                expect(scope.requestedMedia).toEqual('');
            });

            it ("should return one image type if there is only one mediaType", function () {
                scope.mediaRequest = {
                    mediaTypes: [
                        {
                            "description": "Head and Face"
                        }
                    ],
                    providerContacts: []
                };

                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.$apply();
                expect(scope.requestedMedia).toEqual('Head and Face');
            });

            it ("should return a comma-separated list of image types if there is more than one mediaType", function () {
                scope.mediaRequest = {
                    mediaTypes: [
                        {
                            "description": "Head and Face"
                        },
                        {
                            "description": "Left Side of Face"
                        },
                        {
                            "description": "Right Side of Face"
                        }
                    ],
                    providerContacts: []
                };

                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.$apply();
                expect(scope.requestedMedia).toEqual('Head and Face, Left Side of Face, Right Side of Face');
            });
        });

        describe('continue function', function () {
            it ('should call the continueCallback', function () {
                scope.continueCallback = function () {};
                spyOn(scope, 'continueCallback');
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.continue();
                expect(scope.continueCallback).toHaveBeenCalled();
            });
        });

        describe('review function', function () {
            it ('should call the reviewCallback', function () {
                scope.reviewCallback = function (event) {};
                spyOn(scope, 'reviewCallback');
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.review(eventMock);
                expect(scope.reviewCallback).toHaveBeenCalled();
            });
        });

        describe('back function', function () {
            it ('should go to the previous page', function () {
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
                scope.routeBase = 'test.test';
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.back();
                expect(stateMock.go).toHaveBeenCalledWith('test.test');
            });
        });

        describe("setting the current date", function () {
            it("should correctly set current date", function () {
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
     
                var date = new Date(),
                    formattedDate = ("0" + (date.getMonth() + 1)).slice(-2) + "/" + ("0" + date.getDate()).slice(-2) + "/" + date.getFullYear();
                
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.$apply();

                expect(scope.todayDate).toEqual(formattedDate);
            });
        });

        describe("the date range validation check", function () {
            it("should be defined", function () {
                scope.mediaRequest = {
                    mediaTypes: [],
                    providerContacts: []
                };
           
                controller = controller('MediaRequestInfoController', {$scope: scope});
                scope.$apply();

                expect(scope.isValidDateRange).toBeDefined();
            });
        });
    });
});