define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('consentService', function ($q, localStorageService, userSessionService, sessionStorageService) {
        return {
            consentAccepted: false,
            showConsent: function (user) {
                this.consentAccepted = this.consentAccepted || !sessionStorageService.showModal(user, 'consent') || !localStorageService.showModal(user, 'consent');

                return !this.consentAccepted;
            },
            consent: function (noShowSelected) {
                var deferred = $q.defer(),
                    that = this;

                this.consentAccepted = true;

                userSessionService.fetch().then(function (user) {
                    sessionStorage.setItem(sessionStorageService.keys['consent'], true);
                    
                    if (noShowSelected) {
                        localStorage.setItem(localStorageService.keys['consent'], true);
                    }

                    deferred.resolve();
                }, function(error) {
                    deferred.reject(error);
                });

                return deferred.promise;
            }
        };
    });
});